/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.test.fixtures;

import com.swirlds.state.spi.ReadableQueueStateBase;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;

public class ListReadableQueueState<E>
extends ReadableQueueStateBase<E> {
    private final Queue<E> backingStore;

    public ListReadableQueueState(@NonNull String serviceName, @NonNull String stateKey, @NonNull Queue<E> backingStore) {
        super(serviceName, stateKey);
        this.backingStore = Objects.requireNonNull(backingStore);
    }

    @Nullable
    protected E peekOnDataSource() {
        return this.backingStore.peek();
    }

    @NonNull
    protected Iterator<E> iterateOnDataSource() {
        return this.backingStore.iterator();
    }

    @NonNull
    public static <E> Builder<E> builder(@NonNull String serviceName, @NonNull String stateKey) {
        return new Builder(serviceName, stateKey);
    }

    public static final class Builder<E> {
        private final Queue<E> backingStore = new LinkedList();
        private final String serviceName;
        private final String stateKey;

        Builder(@NonNull String serviceName, @NonNull String stateKey) {
            this.serviceName = serviceName;
            this.stateKey = stateKey;
        }

        @NonNull
        public Builder<E> value(@NonNull E element) {
            this.backingStore.add(element);
            return this;
        }

        @NonNull
        public ListReadableQueueState<E> build() {
            return new ListReadableQueueState<E>(this.serviceName, this.stateKey, new LinkedList<E>(this.backingStore));
        }
    }
}

