/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.system;

import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.FatalErrorPayload;
import com.swirlds.logging.legacy.payload.SystemExitPayload;
import com.swirlds.platform.system.SystemExitCode;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.StackTrace;

public final class SystemExitUtils {
    private static final Logger logger = LogManager.getLogger(SystemExitUtils.class);

    private SystemExitUtils() {
    }

    public static void exitSystem(@Nullable SystemExitCode suppliedExitCode, @Nullable String message, boolean haltRuntime) {
        SystemExitCode exitCode = suppliedExitCode == null ? SystemExitCode.NO_EXIT_CODE : suppliedExitCode;
        StackTrace stackTrace = StackTrace.getStackTrace();
        String exitMessage = "System exit requested (" + String.valueOf((Object)exitCode) + ")" + (String)(message == null ? "" : "\nmessage: " + message) + "\nthread requesting exit: " + Thread.currentThread().getName() + "\n" + String.valueOf(stackTrace);
        logger.info(LogMarker.STARTUP.getMarker(), exitMessage);
        if (exitCode.isError()) {
            logger.error(LogMarker.EXCEPTION.getMarker(), (Object)new SystemExitPayload(exitCode.name(), exitCode.getExitCode()));
        } else {
            logger.info(LogMarker.STARTUP.getMarker(), (Object)new SystemExitPayload(exitCode.name(), exitCode.getExitCode()));
        }
        System.out.println("Exiting System (" + exitCode.name() + ")");
        System.exit(exitCode.getExitCode());
        if (haltRuntime) {
            Runtime.getRuntime().halt(exitCode.getExitCode());
        }
    }

    public static void exitSystem(@NonNull SystemExitCode exitCode, @Nullable String message) {
        SystemExitUtils.exitSystem(exitCode, message, false);
    }

    public static void exitSystem(@NonNull SystemExitCode exitCode) {
        SystemExitUtils.exitSystem(exitCode, null, false);
    }

    public static void handleFatalError(@Nullable String msg, @Nullable Throwable throwable, @NonNull SystemExitCode exitCode) {
        logger.fatal(LogMarker.EXCEPTION.getMarker(), "{}\nCaller stack trace:\n{}\nThrowable provided:", (Object)new FatalErrorPayload("Fatal error, node will shut down. Reason: " + msg), (Object)StackTrace.getStackTrace().toString(), (Object)throwable);
        SystemExitUtils.exitSystem(exitCode, msg);
    }
}

