/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.pipeline;

import com.swirlds.virtualmap.internal.pipeline.PipelineListNode;
import java.util.function.Predicate;

class PipelineList<T> {
    private PipelineListNode<T> first;
    private PipelineListNode<T> last;
    private int size;

    PipelineList() {
    }

    synchronized PipelineListNode<T> getFirst() {
        return this.first;
    }

    synchronized void add(T value) {
        PipelineListNode<T> node = new PipelineListNode<T>(value);
        if (this.first == null) {
            this.first = node;
        } else {
            this.last.addNext(node);
        }
        this.last = node;
        ++this.size;
    }

    synchronized void remove(PipelineListNode<T> node) {
        if (this.first == node) {
            this.first = node.getNext();
        }
        if (this.last == node) {
            this.last = node.getPrevious();
        }
        node.remove();
        --this.size;
    }

    synchronized boolean testAll(Predicate<T> predicate) {
        for (PipelineListNode<T> target = this.first; target != null; target = target.getNext()) {
            if (predicate.test(target.getValue())) continue;
            return false;
        }
        return true;
    }

    synchronized int getSize() {
        return this.size;
    }
}

