/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.wiring;

import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.IOIterator;
import com.swirlds.common.stream.RunningEventHashOverride;
import com.swirlds.component.framework.component.ComponentWiring;
import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerConfiguration;
import com.swirlds.component.framework.transformers.AdvancedTransformation;
import com.swirlds.component.framework.transformers.WireFilter;
import com.swirlds.component.framework.wires.SolderType;
import com.swirlds.component.framework.wires.input.InputWire;
import com.swirlds.component.framework.wires.output.OutputWire;
import com.swirlds.component.framework.wires.output.StandardOutputWire;
import com.swirlds.platform.builder.ApplicationCallbacks;
import com.swirlds.platform.builder.ExecutionLayer;
import com.swirlds.platform.builder.PlatformComponentBuilder;
import com.swirlds.platform.components.AppNotifier;
import com.swirlds.platform.components.EventWindowManager;
import com.swirlds.platform.components.SavedStateController;
import com.swirlds.platform.components.appcomm.CompleteStateNotificationWithCleanup;
import com.swirlds.platform.components.appcomm.LatestCompleteStateNotifier;
import com.swirlds.platform.components.consensus.ConsensusEngine;
import com.swirlds.platform.components.consensus.ConsensusEngineOutput;
import com.swirlds.platform.event.branching.BranchDetector;
import com.swirlds.platform.event.branching.BranchReporter;
import com.swirlds.platform.event.deduplication.EventDeduplicator;
import com.swirlds.platform.event.orphan.OrphanBuffer;
import com.swirlds.platform.event.preconsensus.InlinePcesWriter;
import com.swirlds.platform.event.preconsensus.PcesReplayer;
import com.swirlds.platform.event.stream.ConsensusEventStream;
import com.swirlds.platform.event.validation.EventSignatureValidator;
import com.swirlds.platform.event.validation.InternalEventValidator;
import com.swirlds.platform.eventhandling.StateWithHashComplexity;
import com.swirlds.platform.eventhandling.TransactionHandler;
import com.swirlds.platform.eventhandling.TransactionHandlerResult;
import com.swirlds.platform.eventhandling.TransactionPrehandler;
import com.swirlds.platform.publisher.PlatformPublisher;
import com.swirlds.platform.state.hasher.StateHasher;
import com.swirlds.platform.state.hashlogger.HashLogger;
import com.swirlds.platform.state.iss.IssDetector;
import com.swirlds.platform.state.iss.IssHandler;
import com.swirlds.platform.state.nexus.LatestCompleteStateNexus;
import com.swirlds.platform.state.nexus.SignedStateNexus;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.state.signed.SignedStateSentinel;
import com.swirlds.platform.state.signed.StateGarbageCollector;
import com.swirlds.platform.state.signed.StateSignatureCollector;
import com.swirlds.platform.state.signer.StateSigner;
import com.swirlds.platform.state.snapshot.StateDumpRequest;
import com.swirlds.platform.state.snapshot.StateSnapshotManager;
import com.swirlds.platform.system.state.notifications.StateHashedNotification;
import com.swirlds.platform.system.status.PlatformStatusConfig;
import com.swirlds.platform.system.status.StatusActionSubmitter;
import com.swirlds.platform.system.status.StatusStateMachine;
import com.swirlds.platform.wiring.NoInput;
import com.swirlds.platform.wiring.PlatformCoordinator;
import com.swirlds.platform.wiring.PlatformSchedulersConfig;
import com.swirlds.platform.wiring.SignedStateReserver;
import com.swirlds.platform.wiring.StateWithHashComplexityReserver;
import com.swirlds.platform.wiring.StateWithHashComplexityToStateReserver;
import com.swirlds.platform.wiring.components.GossipWiring;
import com.swirlds.platform.wiring.components.PcesReplayerWiring;
import com.swirlds.platform.wiring.components.RunningEventHashOverrideWiring;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import org.hiero.consensus.crypto.EventHasher;
import org.hiero.consensus.event.creator.impl.EventCreationManager;
import org.hiero.consensus.event.creator.impl.config.EventCreationConfig;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.ConsensusRound;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.notification.IssNotification;
import org.hiero.consensus.model.state.StateSavingResult;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.model.transaction.ScopedSystemTransaction;
import org.hiero.consensus.roster.RosterHistory;

public class PlatformWiring {
    private final WiringModel model;
    private final PlatformContext platformContext;
    private final PlatformSchedulersConfig config;
    private final ComponentWiring<EventHasher, PlatformEvent> eventHasherWiring;
    private final ComponentWiring<InternalEventValidator, PlatformEvent> internalEventValidatorWiring;
    private final ComponentWiring<EventDeduplicator, PlatformEvent> eventDeduplicatorWiring;
    private final ComponentWiring<EventSignatureValidator, PlatformEvent> eventSignatureValidatorWiring;
    private final ComponentWiring<OrphanBuffer, List<PlatformEvent>> orphanBufferWiring;
    private final ComponentWiring<ConsensusEngine, ConsensusEngineOutput> consensusEngineWiring;
    private final OutputWire<List<ConsensusRound>> consensusRoundsOutputWire;
    private final ComponentWiring<EventCreationManager, PlatformEvent> eventCreationManagerWiring;
    private final ComponentWiring<StateSnapshotManager, StateSavingResult> stateSnapshotManagerWiring;
    private final ComponentWiring<StateSigner, StateSignatureTransaction> stateSignerWiring;
    private final PcesReplayerWiring pcesReplayerWiring;
    private final ComponentWiring<InlinePcesWriter, PlatformEvent> pcesInlineWriterWiring;
    private final ComponentWiring<TransactionPrehandler, Queue<ScopedSystemTransaction<StateSignatureTransaction>>> applicationTransactionPrehandlerWiring;
    private final ComponentWiring<StateSignatureCollector, List<ReservedSignedState>> stateSignatureCollectorWiring;
    private final GossipWiring gossipWiring;
    private final ComponentWiring<EventWindowManager, EventWindow> eventWindowManagerWiring;
    private final ComponentWiring<TransactionHandler, TransactionHandlerResult> transactionHandlerWiring;
    private final ComponentWiring<ConsensusEventStream, Void> consensusEventStreamWiring;
    private final RunningEventHashOverrideWiring runningEventHashOverrideWiring;
    private final ComponentWiring<IssDetector, List<IssNotification>> issDetectorWiring;
    private final ComponentWiring<IssHandler, Void> issHandlerWiring;
    private final ComponentWiring<HashLogger, Void> hashLoggerWiring;
    private final ComponentWiring<LatestCompleteStateNotifier, CompleteStateNotificationWithCleanup> latestCompleteStateNotifierWiring;
    private final ComponentWiring<SignedStateNexus, Void> latestImmutableStateNexusWiring;
    private final ComponentWiring<LatestCompleteStateNexus, Void> latestCompleteStateNexusWiring;
    private final ComponentWiring<SavedStateController, StateWithHashComplexity> savedStateControllerWiring;
    private final ComponentWiring<StateHasher, ReservedSignedState> stateHasherWiring;
    private final PlatformCoordinator platformCoordinator;
    private final ComponentWiring<AppNotifier, Void> notifierWiring;
    private final ComponentWiring<StateGarbageCollector, Void> stateGarbageCollectorWiring;
    private final ComponentWiring<SignedStateSentinel, Void> signedStateSentinelWiring;
    private final ComponentWiring<PlatformPublisher, Void> platformPublisherWiring;
    private final boolean publishPreconsensusEvents;
    private final boolean publishSnapshotOverrides;
    private final boolean publishStaleEvents;
    private final ExecutionLayer execution;
    private final ComponentWiring<StatusStateMachine, PlatformStatus> statusStateMachineWiring;
    private final ComponentWiring<BranchDetector, PlatformEvent> branchDetectorWiring;
    private final ComponentWiring<BranchReporter, Void> branchReporterWiring;

    public PlatformWiring(@NonNull PlatformContext platformContext, @NonNull WiringModel model, @NonNull ApplicationCallbacks applicationCallbacks, @NonNull ExecutionLayer execution) {
        this.platformContext = Objects.requireNonNull(platformContext);
        this.model = Objects.requireNonNull(model);
        this.execution = Objects.requireNonNull(execution);
        this.config = (PlatformSchedulersConfig)platformContext.getConfiguration().getConfigData(PlatformSchedulersConfig.class);
        this.eventHasherWiring = new ComponentWiring(model, EventHasher.class, this.config.eventHasher());
        this.internalEventValidatorWiring = new ComponentWiring(model, InternalEventValidator.class, this.config.internalEventValidator());
        this.eventDeduplicatorWiring = new ComponentWiring(model, EventDeduplicator.class, this.config.eventDeduplicator());
        this.eventSignatureValidatorWiring = new ComponentWiring(model, EventSignatureValidator.class, this.config.eventSignatureValidator());
        this.orphanBufferWiring = new ComponentWiring(model, OrphanBuffer.class, this.config.orphanBuffer());
        this.consensusEngineWiring = new ComponentWiring(model, ConsensusEngine.class, this.config.consensusEngine());
        this.consensusRoundsOutputWire = this.consensusEngineWiring.getOutputWire().buildTransformer("ConsensusRounds", "consensusEngineOutput", ConsensusEngineOutput::consensusRounds);
        this.eventCreationManagerWiring = new ComponentWiring(model, EventCreationManager.class, this.config.eventCreationManager());
        this.applicationTransactionPrehandlerWiring = new ComponentWiring(model, TransactionPrehandler.class, this.config.applicationTransactionPrehandler());
        this.stateSignatureCollectorWiring = new ComponentWiring(model, StateSignatureCollector.class, this.config.stateSignatureCollector());
        this.stateSnapshotManagerWiring = new ComponentWiring(model, StateSnapshotManager.class, this.config.stateSnapshotManager());
        this.stateSignerWiring = new ComponentWiring(model, StateSigner.class, this.config.stateSigner());
        this.transactionHandlerWiring = new ComponentWiring(model, TransactionHandler.class, this.config.transactionHandler(), data -> {
            int n;
            if (data instanceof ConsensusRound) {
                ConsensusRound consensusRound = (ConsensusRound)data;
                n = Math.max(consensusRound.getNumAppTransactions(), 1);
            } else {
                n = 1;
            }
            return n;
        });
        this.consensusEventStreamWiring = new ComponentWiring(model, ConsensusEventStream.class, this.config.consensusEventStream());
        this.runningEventHashOverrideWiring = RunningEventHashOverrideWiring.create(model);
        this.stateHasherWiring = new ComponentWiring(model, StateHasher.class, this.config.stateHasher(), data -> {
            long l;
            if (data instanceof StateWithHashComplexity) {
                StateWithHashComplexity swhc = (StateWithHashComplexity)data;
                l = swhc.hashComplexity();
            } else {
                l = 1L;
            }
            return l;
        });
        this.gossipWiring = new GossipWiring(platformContext, model);
        this.pcesReplayerWiring = PcesReplayerWiring.create(model);
        this.pcesInlineWriterWiring = new ComponentWiring(model, InlinePcesWriter.class, this.config.pcesInlineWriter());
        this.eventWindowManagerWiring = new ComponentWiring(model, EventWindowManager.class, TaskSchedulerConfiguration.DIRECT_THREADSAFE_CONFIGURATION);
        this.issDetectorWiring = new ComponentWiring(model, IssDetector.class, this.config.issDetector());
        this.issHandlerWiring = new ComponentWiring(model, IssHandler.class, this.config.issHandler());
        this.hashLoggerWiring = new ComponentWiring(model, HashLogger.class, this.config.hashLogger());
        this.latestCompleteStateNotifierWiring = new ComponentWiring(model, LatestCompleteStateNotifier.class, this.config.latestCompleteStateNotifier());
        this.latestImmutableStateNexusWiring = new ComponentWiring(model, SignedStateNexus.class, TaskSchedulerConfiguration.DIRECT_THREADSAFE_CONFIGURATION);
        this.latestCompleteStateNexusWiring = new ComponentWiring(model, LatestCompleteStateNexus.class, TaskSchedulerConfiguration.DIRECT_THREADSAFE_CONFIGURATION);
        this.savedStateControllerWiring = new ComponentWiring(model, SavedStateController.class, TaskSchedulerConfiguration.DIRECT_THREADSAFE_CONFIGURATION);
        this.notifierWiring = new ComponentWiring(model, AppNotifier.class, TaskSchedulerConfiguration.DIRECT_THREADSAFE_CONFIGURATION);
        this.publishPreconsensusEvents = applicationCallbacks.preconsensusEventConsumer() != null;
        this.publishSnapshotOverrides = applicationCallbacks.snapshotOverrideConsumer() != null;
        this.publishStaleEvents = applicationCallbacks.staleEventConsumer() != null;
        TaskSchedulerConfiguration publisherConfiguration = this.publishPreconsensusEvents || this.publishSnapshotOverrides || this.publishStaleEvents ? this.config.platformPublisher() : TaskSchedulerConfiguration.NO_OP_CONFIGURATION;
        this.platformPublisherWiring = new ComponentWiring(model, PlatformPublisher.class, publisherConfiguration);
        this.stateGarbageCollectorWiring = new ComponentWiring(model, StateGarbageCollector.class, this.config.stateGarbageCollector());
        this.signedStateSentinelWiring = new ComponentWiring(model, SignedStateSentinel.class, this.config.signedStateSentinel());
        this.statusStateMachineWiring = new ComponentWiring(model, StatusStateMachine.class, this.config.statusStateMachine());
        this.branchDetectorWiring = new ComponentWiring(model, BranchDetector.class, this.config.branchDetector());
        this.branchReporterWiring = new ComponentWiring(model, BranchReporter.class, this.config.branchReporter());
        this.platformCoordinator = new PlatformCoordinator(() -> this.eventHasherWiring.flush(), this.internalEventValidatorWiring, this.eventDeduplicatorWiring, this.eventSignatureValidatorWiring, this.orphanBufferWiring, this.gossipWiring, this.consensusEngineWiring, this.eventCreationManagerWiring, this.applicationTransactionPrehandlerWiring, this.stateSignatureCollectorWiring, this.transactionHandlerWiring, this.stateHasherWiring, this.statusStateMachineWiring, this.branchDetectorWiring, this.branchReporterWiring, this.pcesInlineWriterWiring);
        this.wire();
    }

    @NonNull
    public WiringModel getModel() {
        return this.model;
    }

    private void solderEventWindow() {
        OutputWire eventWindowOutputWire = this.eventWindowManagerWiring.getOutputWire();
        eventWindowOutputWire.solderTo(this.eventDeduplicatorWiring.getInputWire(EventDeduplicator::setEventWindow), SolderType.INJECT);
        eventWindowOutputWire.solderTo(this.eventSignatureValidatorWiring.getInputWire(EventSignatureValidator::setEventWindow), SolderType.INJECT);
        eventWindowOutputWire.solderTo(this.orphanBufferWiring.getInputWire(OrphanBuffer::setEventWindow), SolderType.INJECT);
        eventWindowOutputWire.solderTo(this.gossipWiring.getEventWindowInput(), SolderType.INJECT);
        eventWindowOutputWire.solderTo(this.pcesInlineWriterWiring.getInputWire(InlinePcesWriter::updateNonAncientEventBoundary), SolderType.INJECT);
        eventWindowOutputWire.solderTo(this.eventCreationManagerWiring.getInputWire(EventCreationManager::setEventWindow), SolderType.INJECT);
        eventWindowOutputWire.solderTo(this.latestCompleteStateNexusWiring.getInputWire(LatestCompleteStateNexus::updateEventWindow));
        eventWindowOutputWire.solderTo(this.branchDetectorWiring.getInputWire(BranchDetector::updateEventWindow), SolderType.INJECT);
        eventWindowOutputWire.solderTo(this.branchReporterWiring.getInputWire(BranchReporter::updateEventWindow), SolderType.INJECT);
    }

    private void solderNotifier() {
        this.latestCompleteStateNotifierWiring.getOutputWire().solderTo(this.notifierWiring.getInputWire(AppNotifier::sendLatestCompleteStateNotification));
        this.stateSnapshotManagerWiring.getTransformedOutput(StateSnapshotManager::toNotification).solderTo(this.notifierWiring.getInputWire(AppNotifier::sendStateWrittenToDiskNotification), SolderType.INJECT);
        OutputWire issNotificationOutputWire = this.issDetectorWiring.getSplitOutput();
        issNotificationOutputWire.solderTo(this.notifierWiring.getInputWire(AppNotifier::sendIssNotification));
        this.statusStateMachineWiring.getOutputWire().solderTo(this.notifierWiring.getInputWire(AppNotifier::sendPlatformStatusChangeNotification));
    }

    private void wire() {
        InputWire hasherInputWire = this.eventHasherWiring.getInputWire(EventHasher::hashEvent, "unhashed event");
        this.gossipWiring.getEventOutput().solderTo(hasherInputWire);
        this.gossipWiring.getSyncLagOutput().solderTo(this.eventCreationManagerWiring.getInputWire(EventCreationManager::reportSyncRoundLag));
        this.eventHasherWiring.getOutputWire().solderTo(this.internalEventValidatorWiring.getInputWire(InternalEventValidator::validateEvent));
        this.internalEventValidatorWiring.getOutputWire().solderTo(this.eventDeduplicatorWiring.getInputWire(EventDeduplicator::handleEvent));
        this.eventDeduplicatorWiring.getOutputWire().solderTo(this.eventSignatureValidatorWiring.getInputWire(EventSignatureValidator::validateSignature));
        this.eventSignatureValidatorWiring.getOutputWire().solderTo(this.orphanBufferWiring.getInputWire(OrphanBuffer::handleEvent));
        OutputWire splitOrphanBufferOutput = this.orphanBufferWiring.getSplitOutput();
        splitOrphanBufferOutput.solderTo(this.pcesInlineWriterWiring.getInputWire(InlinePcesWriter::writeEvent));
        this.pcesInlineWriterWiring.getOutputWire().solderTo(this.consensusEngineWiring.getInputWire(ConsensusEngine::addEvent));
        this.pcesInlineWriterWiring.getOutputWire().solderTo(this.gossipWiring.getEventInput(), SolderType.INJECT);
        this.pcesInlineWriterWiring.getOutputWire().solderTo(this.eventCreationManagerWiring.getInputWire(EventCreationManager::registerEvent));
        this.model.getHealthMonitorWire().solderTo(this.eventCreationManagerWiring.getInputWire(EventCreationManager::reportUnhealthyDuration));
        this.model.getHealthMonitorWire().solderTo(this.gossipWiring.getSystemHealthInput());
        this.model.getHealthMonitorWire().solderTo("executionHealthInput", "healthyDuration", this.execution::reportUnhealthyDuration);
        splitOrphanBufferOutput.solderTo(this.branchDetectorWiring.getInputWire(BranchDetector::checkForBranches));
        this.branchDetectorWiring.getOutputWire().solderTo(this.branchReporterWiring.getInputWire(BranchReporter::reportBranch));
        double eventCreationHeartbeatFrequency = ((EventCreationConfig)this.platformContext.getConfiguration().getConfigData(EventCreationConfig.class)).creationAttemptRate();
        this.model.buildHeartbeatWire(eventCreationHeartbeatFrequency).solderTo(this.eventCreationManagerWiring.getInputWire(EventCreationManager::maybeCreateEvent), SolderType.OFFER);
        this.model.buildHeartbeatWire(((PlatformStatusConfig)this.platformContext.getConfiguration().getConfigData(PlatformStatusConfig.class)).statusStateMachineHeartbeatPeriod()).solderTo(this.statusStateMachineWiring.getInputWire(StatusStateMachine::heartbeat), SolderType.OFFER);
        this.eventCreationManagerWiring.getOutputWire().solderTo(this.internalEventValidatorWiring.getInputWire(InternalEventValidator::validateEvent), SolderType.INJECT);
        if (this.publishStaleEvents) {
            OutputWire staleEvent = this.consensusEngineWiring.getOutputWire().buildTransformer("staleEvents", "consensusEngineOutput", ConsensusEngineOutput::staleEvents).buildSplitter("staleEventsSplitter", "stale events");
            staleEvent.solderTo(this.platformPublisherWiring.getInputWire(PlatformPublisher::publishStaleEvent));
        }
        OutputWire consEngineAddedEvents = this.consensusEngineWiring.getOutputWire().buildTransformer("PreConsensusEvents", "consensusEngineOutput", ConsensusEngineOutput::preConsensusEvents).buildSplitter("PreConsensusEventsSplitter", "preConsensusEvents");
        consEngineAddedEvents.solderTo(this.applicationTransactionPrehandlerWiring.getInputWire(TransactionPrehandler::prehandleApplicationTransactions));
        this.applicationTransactionPrehandlerWiring.getOutputWire().solderTo(this.stateSignatureCollectorWiring.getInputWire(StateSignatureCollector::handlePreconsensusSignatures));
        OutputWire splitReservedSignedStateWire = this.stateSignatureCollectorWiring.getOutputWire().buildSplitter("reservedStateSplitter", "reserved state lists");
        OutputWire allReservedSignedStatesWire = splitReservedSignedStateWire.buildAdvancedTransformer((AdvancedTransformation)new SignedStateReserver("allStatesReserver"));
        WireFilter saveToDiskFilter = new WireFilter(this.model, "saveToDiskFilter", "states", state -> {
            if (state.get().isStateToSave()) {
                return true;
            }
            state.close();
            return false;
        });
        allReservedSignedStatesWire.solderTo(saveToDiskFilter.getInputWire());
        saveToDiskFilter.getOutputWire().solderTo(this.stateSnapshotManagerWiring.getInputWire(StateSnapshotManager::saveStateTask));
        OutputWire completeReservedSignedStatesWire = allReservedSignedStatesWire.buildFilter("completeStateFilter", "states", rs -> {
            if (rs.get().isComplete()) {
                return true;
            }
            rs.close();
            return false;
        }).buildAdvancedTransformer((AdvancedTransformation)new SignedStateReserver("completeStatesReserver"));
        completeReservedSignedStatesWire.solderTo(this.latestCompleteStateNexusWiring.getInputWire(LatestCompleteStateNexus::setStateIfNewer));
        this.solderEventWindow();
        this.pcesReplayerWiring.eventOutput().solderTo(hasherInputWire);
        OutputWire consensusRoundOutputWire = this.consensusRoundsOutputWire.buildSplitter("ConsensusRoundsSplitter", "consensus rounds");
        this.pcesReplayerWiring.doneStreamingPcesOutputWire().solderTo(this.pcesInlineWriterWiring.getInputWire(InlinePcesWriter::beginStreamingNewEvents));
        consensusRoundOutputWire.solderTo(this.transactionHandlerWiring.getInputWire(TransactionHandler::handleConsensusRound));
        consensusRoundOutputWire.solderTo(this.eventWindowManagerWiring.getInputWire(EventWindowManager::extractEventWindow));
        consensusRoundOutputWire.buildTransformer("RoundsToCesEvents", "consensus rounds", ConsensusRound::getStreamedEvents).solderTo(this.consensusEventStreamWiring.getInputWire(ConsensusEventStream::addEvents));
        OutputWire transactionHandlerSysTxnsOutputWire = this.transactionHandlerWiring.getOutputWire().buildTransformer("getSystemTransactions", "transaction handler result", TransactionHandlerResult::systemTransactions);
        transactionHandlerSysTxnsOutputWire.solderTo(this.stateSignatureCollectorWiring.getInputWire(StateSignatureCollector::handlePostconsensusSignatures));
        transactionHandlerSysTxnsOutputWire.solderTo(this.issDetectorWiring.getInputWire(IssDetector::handleStateSignatureTransactions));
        OutputWire transactionHandlerStateWithComplexityOutput = this.transactionHandlerWiring.getOutputWire().buildFilter("notNullStateFilter", "transaction handler result", thr -> thr.stateWithHashComplexity() != null).buildAdvancedTransformer((AdvancedTransformation)new StateWithHashComplexityReserver("postHandler_stateWithHashComplexityReserver"));
        transactionHandlerStateWithComplexityOutput.solderTo(this.savedStateControllerWiring.getInputWire(SavedStateController::markSavedState));
        OutputWire transactionHandlerStateOnlyOutput = transactionHandlerStateWithComplexityOutput.buildAdvancedTransformer((AdvancedTransformation)new StateWithHashComplexityToStateReserver("postHandler_stateWithHashComplexityToStateReserver"));
        transactionHandlerStateOnlyOutput.solderTo(this.latestImmutableStateNexusWiring.getInputWire(SignedStateNexus::setState));
        transactionHandlerStateOnlyOutput.solderTo(this.stateGarbageCollectorWiring.getInputWire(StateGarbageCollector::registerState));
        this.savedStateControllerWiring.getOutputWire().solderTo(this.stateHasherWiring.getInputWire(StateHasher::hashState));
        this.model.buildHeartbeatWire(this.config.stateGarbageCollectorHeartbeatPeriod()).solderTo(this.stateGarbageCollectorWiring.getInputWire(StateGarbageCollector::heartbeat), SolderType.OFFER);
        this.model.buildHeartbeatWire(this.config.signedStateSentinelHeartbeatPeriod()).solderTo(this.signedStateSentinelWiring.getInputWire(SignedStateSentinel::checkSignedStates), SolderType.OFFER);
        OutputWire hashedStateOutputWire = this.stateHasherWiring.getOutputWire().buildAdvancedTransformer((AdvancedTransformation)new SignedStateReserver("postHasher_stateReserver"));
        hashedStateOutputWire.solderTo(this.hashLoggerWiring.getInputWire(HashLogger::logHashes));
        hashedStateOutputWire.solderTo(this.stateSignerWiring.getInputWire(StateSigner::signState));
        hashedStateOutputWire.solderTo(this.issDetectorWiring.getInputWire(IssDetector::handleState));
        hashedStateOutputWire.buildTransformer("postHasher_notifier", "hashed states", StateHashedNotification::from).solderTo(this.notifierWiring.getInputWire(AppNotifier::sendStateHashedNotification));
        this.stateSignerWiring.getOutputWire().solderTo("ExecutionSignatureSubmission", "state signatures", this.execution::submitStateSignature);
        hashedStateOutputWire.solderTo(this.stateSignatureCollectorWiring.getInputWire(StateSignatureCollector::addReservedState));
        this.stateSnapshotManagerWiring.getTransformedOutput(StateSnapshotManager::extractOldestMinimumBirthRoundOnDisk).solderTo(this.pcesInlineWriterWiring.getInputWire(InlinePcesWriter::setMinimumAncientIdentifierToStore), SolderType.INJECT);
        this.stateSnapshotManagerWiring.getTransformedOutput(StateSnapshotManager::toStateWrittenToDiskAction).solderTo(this.statusStateMachineWiring.getInputWire(StatusStateMachine::submitStatusAction));
        this.runningEventHashOverrideWiring.runningHashUpdateOutput().solderTo(this.transactionHandlerWiring.getInputWire(TransactionHandler::updateLegacyRunningEventHash));
        this.runningEventHashOverrideWiring.runningHashUpdateOutput().solderTo(this.consensusEventStreamWiring.getInputWire(ConsensusEventStream::legacyHashOverride));
        OutputWire splitIssDetectorOutput = this.issDetectorWiring.getSplitOutput();
        splitIssDetectorOutput.solderTo(this.issHandlerWiring.getInputWire(IssHandler::issObserved));
        this.issDetectorWiring.getSplitAndTransformedOutput(IssDetector::getStatusAction).solderTo(this.statusStateMachineWiring.getInputWire(StatusStateMachine::submitStatusAction));
        completeReservedSignedStatesWire.solderTo(this.latestCompleteStateNotifierWiring.getInputWire(LatestCompleteStateNotifier::latestCompleteStateHandler));
        this.statusStateMachineWiring.getOutputWire().solderTo(this.eventCreationManagerWiring.getInputWire(EventCreationManager::updatePlatformStatus));
        this.statusStateMachineWiring.getOutputWire().solderTo(this.consensusEngineWiring.getInputWire(ConsensusEngine::updatePlatformStatus), SolderType.INJECT);
        this.statusStateMachineWiring.getOutputWire().solderTo("ExecutionStatusHandler", "status updates", this.execution::newPlatformStatus);
        this.statusStateMachineWiring.getOutputWire().solderTo(this.gossipWiring.getPlatformStatusInput(), SolderType.INJECT);
        this.solderNotifier();
        if (this.publishPreconsensusEvents) {
            splitOrphanBufferOutput.solderTo(this.platformPublisherWiring.getInputWire(PlatformPublisher::publishPreconsensusEvent));
        }
        this.buildUnsolderedWires();
    }

    private void buildUnsolderedWires() {
        this.eventDeduplicatorWiring.getInputWire(EventDeduplicator::clear);
        this.consensusEngineWiring.getInputWire(ConsensusEngine::outOfBandSnapshotUpdate);
        if (this.publishSnapshotOverrides) {
            this.platformPublisherWiring.getInputWire(PlatformPublisher::publishSnapshotOverride);
        }
        this.eventCreationManagerWiring.getInputWire(EventCreationManager::clear);
        this.notifierWiring.getInputWire(AppNotifier::sendReconnectCompleteNotification);
        this.notifierWiring.getInputWire(AppNotifier::sendPlatformStatusChangeNotification);
        this.eventSignatureValidatorWiring.getInputWire(EventSignatureValidator::updateRosterHistory);
        this.eventWindowManagerWiring.getInputWire(EventWindowManager::updateEventWindow);
        this.orphanBufferWiring.getInputWire(OrphanBuffer::clear);
        this.pcesInlineWriterWiring.getInputWire(InlinePcesWriter::registerDiscontinuity);
        this.stateSignatureCollectorWiring.getInputWire(StateSignatureCollector::clear);
        this.issDetectorWiring.getInputWire(IssDetector::overridingState);
        this.issDetectorWiring.getInputWire(IssDetector::signalEndOfPreconsensusReplay);
        this.stateSnapshotManagerWiring.getInputWire(StateSnapshotManager::dumpStateTask);
        this.branchDetectorWiring.getInputWire(BranchDetector::clear);
        this.branchReporterWiring.getInputWire(BranchReporter::clear);
    }

    public void bind(@NonNull PlatformComponentBuilder builder, @NonNull PcesReplayer pcesReplayer, @NonNull StateSignatureCollector stateSignatureCollector, @NonNull EventWindowManager eventWindowManager, @Nullable InlinePcesWriter inlinePcesWriter, @NonNull SignedStateNexus latestImmutableStateNexus, @NonNull LatestCompleteStateNexus latestCompleteStateNexus, @NonNull SavedStateController savedStateController, @NonNull AppNotifier notifier, @NonNull PlatformPublisher platformPublisher) {
        this.eventHasherWiring.bind(builder::buildEventHasher);
        this.internalEventValidatorWiring.bind(builder::buildInternalEventValidator);
        this.eventDeduplicatorWiring.bind(builder::buildEventDeduplicator);
        this.eventSignatureValidatorWiring.bind(builder::buildEventSignatureValidator);
        this.orphanBufferWiring.bind(builder::buildOrphanBuffer);
        this.consensusEngineWiring.bind(builder::buildConsensusEngine);
        this.stateSnapshotManagerWiring.bind(builder::buildStateSnapshotManager);
        this.stateSignerWiring.bind(builder::buildStateSigner);
        this.pcesReplayerWiring.bind(pcesReplayer);
        if (inlinePcesWriter != null) {
            this.pcesInlineWriterWiring.bind((Object)inlinePcesWriter);
        } else {
            this.pcesInlineWriterWiring.bind(builder::buildInlinePcesWriter);
        }
        this.eventCreationManagerWiring.bind(builder::buildEventCreationManager);
        this.stateSignatureCollectorWiring.bind((Object)stateSignatureCollector);
        this.eventWindowManagerWiring.bind((Object)eventWindowManager);
        this.applicationTransactionPrehandlerWiring.bind(builder::buildTransactionPrehandler);
        this.transactionHandlerWiring.bind(builder::buildTransactionHandler);
        this.consensusEventStreamWiring.bind(builder::buildConsensusEventStream);
        this.issDetectorWiring.bind(builder::buildIssDetector);
        this.issHandlerWiring.bind(builder::buildIssHandler);
        this.hashLoggerWiring.bind(builder::buildHashLogger);
        this.latestCompleteStateNotifierWiring.bind(builder::buildLatestCompleteStateNotifier);
        this.latestImmutableStateNexusWiring.bind((Object)latestImmutableStateNexus);
        this.latestCompleteStateNexusWiring.bind((Object)latestCompleteStateNexus);
        this.savedStateControllerWiring.bind((Object)savedStateController);
        this.stateHasherWiring.bind(builder::buildStateHasher);
        this.notifierWiring.bind((Object)notifier);
        this.platformPublisherWiring.bind((Object)platformPublisher);
        this.stateGarbageCollectorWiring.bind(builder::buildStateGarbageCollector);
        this.statusStateMachineWiring.bind(builder::buildStatusStateMachine);
        this.signedStateSentinelWiring.bind(builder::buildSignedStateSentinel);
        this.gossipWiring.bind(builder.buildGossip());
        this.branchDetectorWiring.bind(builder::buildBranchDetector);
        this.branchReporterWiring.bind(builder::buildBranchReporter);
    }

    public void startGossip() {
        this.gossipWiring.getStartInput().inject((Object)NoInput.getInstance());
    }

    @NonNull
    public InputWire<RosterHistory> getRosterHistoryInput() {
        return this.eventSignatureValidatorWiring.getInputWire(EventSignatureValidator::updateRosterHistory);
    }

    @NonNull
    public InputWire<StateDumpRequest> getDumpStateToDiskInput() {
        return this.stateSnapshotManagerWiring.getInputWire(StateSnapshotManager::dumpStateTask);
    }

    @NonNull
    public InputWire<ReservedSignedState> getSignatureCollectorStateInput() {
        return this.stateSignatureCollectorWiring.getInputWire(StateSignatureCollector::addReservedState);
    }

    @NonNull
    public InputWire<IOIterator<PlatformEvent>> getPcesReplayerIteratorInput() {
        return this.pcesReplayerWiring.pcesIteratorInputWire();
    }

    @NonNull
    public StandardOutputWire<PlatformEvent> getPcesReplayerEventOutput() {
        return this.pcesReplayerWiring.eventOutput();
    }

    @NonNull
    public InputWire<ReservedSignedState> getHashLoggerInput() {
        return this.hashLoggerWiring.getInputWire(HashLogger::logHashes);
    }

    public void sendStateToHashLogger(@NonNull SignedState signedState) {
        if (signedState.getState().getHash() != null) {
            ReservedSignedState stateReservedForHasher = signedState.reserve("logging state hash");
            boolean offerResult = this.getHashLoggerInput().offer((Object)stateReservedForHasher);
            if (!offerResult) {
                stateReservedForHasher.close();
            }
        }
    }

    @NonNull
    public InputWire<Long> getPcesMinimumGenerationToStoreInput() {
        return this.pcesInlineWriterWiring.getInputWire(InlinePcesWriter::setMinimumAncientIdentifierToStore);
    }

    @NonNull
    public InputWire<Long> getPcesWriterRegisterDiscontinuityInput() {
        return this.pcesInlineWriterWiring.getInputWire(InlinePcesWriter::registerDiscontinuity);
    }

    @NonNull
    public ComponentWiring<AppNotifier, Void> getNotifierWiring() {
        return this.notifierWiring;
    }

    @NonNull
    public OutputWire<List<ConsensusRound>> getConsensusEngineOutputWire() {
        return this.consensusRoundsOutputWire;
    }

    public void updateRunningHash(@NonNull RunningEventHashOverride runningHashUpdate) {
        this.runningEventHashOverrideWiring.runningHashUpdateInput().inject((Object)runningHashUpdate);
    }

    public void overrideIssDetectorState(@NonNull ReservedSignedState state) {
        this.issDetectorWiring.getInputWire(IssDetector::overridingState).put((Object)state);
    }

    public void signalEndOfPcesReplay() {
        this.issDetectorWiring.getInputWire(IssDetector::signalEndOfPreconsensusReplay).put((Object)NoInput.getInstance());
    }

    @NonNull
    public StatusActionSubmitter getStatusActionSubmitter() {
        return action -> this.statusStateMachineWiring.getInputWire(StatusStateMachine::submitStatusAction).put((Object)action);
    }

    @NonNull
    public OutputWire<PlatformStatus> getStatusStateMachineOutputWire() {
        return this.statusStateMachineWiring.getOutputWire();
    }

    public void updateEventWindow(@NonNull EventWindow eventWindow) {
        this.eventWindowManagerWiring.getInputWire(EventWindowManager::updateEventWindow).inject((Object)eventWindow);
        this.gossipWiring.flush();
    }

    public void consensusSnapshotOverride(@NonNull ConsensusSnapshot consensusSnapshot) {
        this.consensusEngineWiring.getInputWire(ConsensusEngine::outOfBandSnapshotUpdate).inject((Object)consensusSnapshot);
        if (this.publishSnapshotOverrides) {
            this.platformPublisherWiring.getInputWire(PlatformPublisher::publishSnapshotOverride).inject((Object)consensusSnapshot);
        }
    }

    public void flushIntakePipeline() {
        this.platformCoordinator.flushIntakePipeline();
    }

    public void flushTransactionHandler() {
        this.transactionHandlerWiring.flush();
    }

    public void flushStateHasher() {
        this.stateHasherWiring.flush();
    }

    public void start() {
        this.model.start();
    }

    public void stop() {
        this.model.stop();
    }

    public void clear() {
        this.platformCoordinator.clear();
    }
}

