/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.sync;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.base.utility.Pair;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.test.fixtures.Randotron;
import com.swirlds.common.test.fixtures.platform.TestPlatformContextBuilder;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.common.threading.pool.CachedPoolParallelExecutor;
import com.swirlds.common.threading.pool.ParallelExecutor;
import com.swirlds.platform.internal.EventImpl;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.test.fixtures.addressbook.RandomRosterBuilder;
import com.swirlds.platform.test.fixtures.event.emitter.EventEmitterFactory;
import com.swirlds.platform.test.fixtures.sync.ConnectionFactory;
import com.swirlds.platform.test.fixtures.sync.SyncNode;
import com.swirlds.platform.test.fixtures.sync.SyncTestParams;
import com.swirlds.platform.test.fixtures.sync.SyncTestUtils;
import com.swirlds.platform.test.fixtures.sync.Synchronizer;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.hiero.base.utility.test.fixtures.RandomUtils;
import org.hiero.consensus.model.test.fixtures.hashgraph.EventWindowBuilder;

public class SyncTestExecutor {
    private final SyncTestParams params;
    private SyncNode caller;
    private SyncNode listener;
    private Consumer<EventEmitterFactory> factoryConfig;
    private Supplier<ParallelExecutor> callerExecutorSupplier;
    private Supplier<ParallelExecutor> listenerExecutorSupplier;
    private ConnectionFactory connectionFactory;
    private Function<EventEmitterFactory, SyncNode> callerSupplier;
    private Function<EventEmitterFactory, SyncNode> listenerSupplier;
    private BiConsumer<SyncNode, SyncNode> initialGraphCreation;
    private BiConsumer<SyncNode, SyncNode> customInitialization;
    private BiConsumer<SyncNode, SyncNode> graphCustomization;
    private BiConsumer<SyncNode, SyncNode> customPreSyncConfiguration;
    private BiConsumer<SyncNode, SyncNode> eventWindowDefinitions;
    private Predicate<EventImpl> callerAddToGraphTest;
    private Predicate<EventImpl> listenerAddToGraphTest;
    private Roster roster;

    public SyncTestExecutor(SyncTestParams params) {
        this.params = params;
        this.roster = RandomRosterBuilder.create((Random)Randotron.create()).withSize(params.getNumNetworkNodes()).build();
        this.factoryConfig = f -> {};
        this.callerExecutorSupplier = () -> {
            CachedPoolParallelExecutor executor = new CachedPoolParallelExecutor(AdHocThreadManager.getStaticThreadManager(), "sync-node");
            executor.start();
            return executor;
        };
        this.listenerExecutorSupplier = () -> {
            CachedPoolParallelExecutor executor = new CachedPoolParallelExecutor(AdHocThreadManager.getStaticThreadManager(), "sync-node");
            executor.start();
            return executor;
        };
        this.callerSupplier = factory -> new SyncNode(params.getNumNetworkNodes(), 0L, factory.newShuffledFromSourceFactory(), this.callerExecutorSupplier.get());
        this.listenerSupplier = factory -> new SyncNode(params.getNumNetworkNodes(), params.getNumNetworkNodes() - 1, factory.newShuffledFromSourceFactory(), this.listenerExecutorSupplier.get());
        this.initialGraphCreation = (caller, listener) -> {
            for (SyncNode node : List.of(caller, listener)) {
                node.getEmitter().setCheckpoint(params.getNumCommonEvents());
                node.generateAndAdd(params.getNumCommonEvents());
                node.setSaveGeneratedEvents(true);
            }
        };
        this.customInitialization = (caller, listener) -> {};
        this.graphCustomization = (caller, listener) -> {};
        this.eventWindowDefinitions = this.updateDefaultEventWindow();
        this.customPreSyncConfiguration = (caller, listener) -> {};
        this.callerAddToGraphTest = indexedEvent -> true;
        this.listenerAddToGraphTest = indexedEvent -> true;
        this.connectionFactory = ConnectionFactory::createLocalConnections;
    }

    @NonNull
    public Roster getRoster() {
        return this.roster;
    }

    public void execute() throws Exception {
        this.initialize();
        this.createGraphs();
        this.preSyncConfiguration();
        this.sync();
    }

    private void initialize() throws IOException {
        Object random;
        if (this.params.getCustomSeed() == null) {
            random = RandomUtils.getRandomPrintSeed();
        } else {
            System.out.println("Using custom seed: " + this.params.getCustomSeed());
            random = new Random(this.params.getCustomSeed());
        }
        PlatformContext platformContext = TestPlatformContextBuilder.create().build();
        EventEmitterFactory factory = new EventEmitterFactory(platformContext, (Random)random, this.roster);
        this.factoryConfig.accept(factory);
        this.caller = this.callerSupplier.apply(factory);
        this.listener = this.listenerSupplier.apply(factory);
        Pair<Connection, Connection> connections = this.connectionFactory.createConnections(this.caller.getNodeId(), this.listener.getNodeId());
        this.caller.setSyncConnection((Connection)connections.left());
        this.listener.setSyncConnection((Connection)connections.right());
        this.customInitialization.accept(this.caller, this.listener);
    }

    private void createGraphs() {
        this.initialGraphCreation.accept(this.caller, this.listener);
        this.graphCustomization.accept(this.caller, this.listener);
        this.caller.getEmitter().setCheckpoint(this.params.getNumCallerEvents());
        this.caller.generateAndAdd(this.params.getNumCallerEvents(), this.callerAddToGraphTest);
        this.listener.getEmitter().setCheckpoint(this.params.getNumListenerEvents());
        this.listener.generateAndAdd(this.params.getNumListenerEvents(), this.listenerAddToGraphTest);
        this.eventWindowDefinitions.accept(this.caller, this.listener);
    }

    private BiConsumer<SyncNode, SyncNode> updateDefaultEventWindow() {
        return (caller, listener) -> {
            List callerTips = caller.getShadowGraph().getTips();
            List listenerTips = listener.getShadowGraph().getTips();
            long listenerExpiredThreshold = SyncTestUtils.getMinIndicator(listener.getShadowGraph().findAncestors((Iterable)listenerTips, e -> true));
            long listenerMaxIndicator = SyncTestUtils.getMaxIndicator(listenerTips);
            long callerExpiredThreshold = SyncTestUtils.getMinIndicator(caller.getShadowGraph().findAncestors((Iterable)callerTips, e -> true));
            long callerMaxIndicator = SyncTestUtils.getMaxIndicator(callerTips);
            long listenerAncientThreshold = listenerExpiredThreshold;
            double listenerDif = listenerMaxIndicator - listenerExpiredThreshold;
            if (listenerDif >= 3.0) {
                listenerAncientThreshold += (long)Math.floor(listenerDif / 3.0);
            } else if (listenerDif == 2.0) {
                ++listenerAncientThreshold;
            }
            long callerAncientThreshold = callerExpiredThreshold;
            double callerDif = callerMaxIndicator - callerExpiredThreshold;
            if (callerDif >= 3.0) {
                callerAncientThreshold += (long)Math.floor(callerDif / 3.0);
            } else if (callerDif == 2.0) {
                ++callerAncientThreshold;
            }
            caller.updateEventWindow(EventWindowBuilder.builder().setAncientThresholdOrGenesis(callerAncientThreshold).setExpiredThresholdOrGenesis(callerExpiredThreshold).build());
            listener.updateEventWindow(EventWindowBuilder.builder().setAncientThresholdOrGenesis(listenerAncientThreshold).setExpiredThresholdOrGenesis(listenerExpiredThreshold).build());
        };
    }

    private void preSyncConfiguration() {
        this.customPreSyncConfiguration.accept(this.caller, this.listener);
    }

    private void sync() throws Exception {
        Synchronizer synchronizer = new Synchronizer();
        long start = System.nanoTime();
        synchronizer.synchronize(this.caller, this.listener);
        long stop = System.nanoTime();
        Duration syncDuration = Duration.ofNanos(stop - start);
        this.caller.drainReceivedEventQueue();
        this.listener.drainReceivedEventQueue();
        System.out.printf("Synced %d events in %d ms%n", this.caller.getReceivedEvents().size() + this.listener.getReceivedEvents().size(), syncDuration.toMillis());
    }

    public void setExecutorSupplier(Supplier<ParallelExecutor> executorSupplier) {
        this.callerExecutorSupplier = executorSupplier;
        this.listenerExecutorSupplier = executorSupplier;
    }

    public void setListenerExecutorSupplier(Supplier<ParallelExecutor> listenerExecutorSupplier) {
        this.listenerExecutorSupplier = listenerExecutorSupplier;
    }

    public void setCallerExecutorSupplier(Supplier<ParallelExecutor> callerExecutorSupplier) {
        this.callerExecutorSupplier = callerExecutorSupplier;
    }

    public void setFactoryConfig(Consumer<EventEmitterFactory> factoryConfig) {
        this.factoryConfig = factoryConfig;
    }

    public void setEventWindowDefinitions(BiConsumer<SyncNode, SyncNode> eventWindowDefinitions) {
        this.eventWindowDefinitions = eventWindowDefinitions;
    }

    public void setCallerSupplier(Function<EventEmitterFactory, SyncNode> callerSupplier) {
        this.callerSupplier = callerSupplier;
    }

    public void setListenerSupplier(Function<EventEmitterFactory, SyncNode> listenerSupplier) {
        this.listenerSupplier = listenerSupplier;
    }

    public void setInitialGraphCreation(BiConsumer<SyncNode, SyncNode> initialGraphCreation) {
        this.initialGraphCreation = initialGraphCreation;
    }

    public void setCustomInitialization(BiConsumer<SyncNode, SyncNode> customInitialization) {
        this.customInitialization = customInitialization;
    }

    public void setGraphCustomization(BiConsumer<SyncNode, SyncNode> graphCustomization) {
        this.graphCustomization = graphCustomization;
    }

    public void setCustomPreSyncConfiguration(BiConsumer<SyncNode, SyncNode> customPreSyncConfiguration) {
        this.customPreSyncConfiguration = customPreSyncConfiguration;
    }

    public void setCallerAddToGraphTest(Predicate<EventImpl> callerAddToGraphTest) {
        this.callerAddToGraphTest = callerAddToGraphTest;
    }

    public void setListenerAddToGraphTest(Predicate<EventImpl> listenerAddToGraphTest) {
        this.listenerAddToGraphTest = listenerAddToGraphTest;
    }

    public SyncNode getCaller() {
        return this.caller;
    }

    public SyncNode getListener() {
        return this.listener;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }
}

