/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.publisher;

import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.builder.ApplicationCallbacks;
import com.swirlds.platform.publisher.PlatformPublisher;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.event.PlatformEvent;

public class DefaultPlatformPublisher
implements PlatformPublisher {
    private static final Logger logger = LogManager.getLogger(DefaultPlatformPublisher.class);
    private final Consumer<PlatformEvent> preconsensusEventConsumer;
    private boolean preconsensusEventConsumerErrorLogged = false;
    private final Consumer<ConsensusSnapshot> snapshotOverrideConsumer;
    private boolean snapshotOverrideConsumerErrorLogged = false;
    private final Consumer<PlatformEvent> staleEventConsumer;
    private boolean staleEventConsumerErrorLogged = false;

    public DefaultPlatformPublisher(@NonNull ApplicationCallbacks applicationCallbacks) {
        this.preconsensusEventConsumer = applicationCallbacks.preconsensusEventConsumer();
        this.snapshotOverrideConsumer = applicationCallbacks.snapshotOverrideConsumer();
        this.staleEventConsumer = applicationCallbacks.staleEventConsumer();
    }

    @Override
    public void publishPreconsensusEvent(@NonNull PlatformEvent event) {
        if (this.preconsensusEventConsumer == null) {
            if (!this.preconsensusEventConsumerErrorLogged) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "No preconsensus event consumer is registered");
                this.preconsensusEventConsumerErrorLogged = true;
            }
            return;
        }
        this.preconsensusEventConsumer.accept(event);
    }

    @Override
    public void publishSnapshotOverride(@NonNull ConsensusSnapshot snapshot) {
        if (this.snapshotOverrideConsumer == null) {
            if (!this.snapshotOverrideConsumerErrorLogged) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "No snapshot override consumer is registered");
                this.snapshotOverrideConsumerErrorLogged = true;
            }
            return;
        }
        this.snapshotOverrideConsumer.accept(snapshot);
    }

    @Override
    public void publishStaleEvent(@NonNull PlatformEvent event) {
        if (this.staleEventConsumer == null) {
            if (!this.staleEventConsumerErrorLogged) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "No stale event consumer is registered");
                this.staleEventConsumerErrorLogged = true;
            }
            return;
        }
        this.staleEventConsumer.accept(event);
    }
}

