/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.disk;

import com.hedera.hapi.platform.state.StateValue;
import com.hedera.pbj.runtime.Codec;
import com.swirlds.state.merkle.StateUtils;
import com.swirlds.state.merkle.disk.OnDiskIterator;
import com.swirlds.state.merkle.logging.StateLogger;
import com.swirlds.state.spi.ReadableKVStateBase;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.Objects;

public final class OnDiskReadableKVState<K, V>
extends ReadableKVStateBase<K, V> {
    @NonNull
    private final VirtualMap virtualMap;
    @NonNull
    private final Codec<K> keyCodec;

    public OnDiskReadableKVState(@NonNull String serviceName, @NonNull String stateKey, @NonNull Codec<K> keyCodec, @NonNull VirtualMap virtualMap) {
        super(serviceName, stateKey);
        this.keyCodec = Objects.requireNonNull(keyCodec);
        this.virtualMap = Objects.requireNonNull(virtualMap);
    }

    protected V readFromDataSource(@NonNull K key) {
        StateValue stateValue = (StateValue)this.virtualMap.get(StateUtils.getStateKeyForKv(this.serviceName, this.stateKey, key), StateValue.PROTOBUF);
        Object value = stateValue != null ? stateValue.value().as() : null;
        StateLogger.logMapGet(StateUtils.computeLabel(this.serviceName, this.stateKey), key, value);
        return (V)value;
    }

    @NonNull
    protected Iterator<K> iterateFromDataSource() {
        StateLogger.logMapIterate(StateUtils.computeLabel(this.serviceName, this.stateKey), this.virtualMap, this.keyCodec);
        return new OnDiskIterator(this.virtualMap, this.keyCodec, StateUtils.stateIdFor(this.serviceName, this.stateKey));
    }

    @Deprecated
    public long size() {
        long size = this.virtualMap.size();
        StateLogger.logMapGetSize(StateUtils.computeLabel(this.serviceName, this.stateKey), size);
        return size;
    }

    public void warm(@NonNull K key) {
        this.virtualMap.warm(StateUtils.getStateKeyForKv(this.serviceName, this.stateKey, key));
    }
}

