/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.schedulers.internal;

import com.swirlds.component.framework.counters.ObjectCounter;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import org.hiero.base.concurrent.AbstractTask;

class ConcurrentTask
extends AbstractTask {
    private final Consumer<Object> handler;
    private final Object data;
    private final ObjectCounter offRamp;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    ConcurrentTask(@NonNull ForkJoinPool pool, @NonNull ObjectCounter offRamp, @NonNull Thread.UncaughtExceptionHandler uncaughtExceptionHandler, @NonNull Consumer<Object> handler, @Nullable Object data) {
        super(pool, 0);
        this.handler = handler;
        this.data = data;
        this.offRamp = offRamp;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    protected boolean onExecute() {
        try {
            this.handler.accept(this.data);
            boolean bl = true;
            return bl;
        }
        finally {
            this.offRamp.offRamp();
        }
    }

    protected void onException(Throwable t) {
        this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), t);
    }
}

