/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures;

import com.swirlds.common.threading.framework.config.ThreadConfiguration;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.hiero.base.CompareTo;
import org.hiero.base.ValueReference;
import org.hiero.base.concurrent.interrupt.InterruptableRunnable;
import org.hiero.base.concurrent.interrupt.InterruptableSupplier;
import org.junit.jupiter.api.Assertions;

public final class AssertionUtils {
    private AssertionUtils() {
    }

    public static void assertEventuallyTrue(BooleanSupplier condition, Duration maxDuration, String message, Supplier<Throwable> cause) {
        Instant start = Instant.now();
        while (!condition.getAsBoolean()) {
            Instant now = Instant.now();
            Duration elapsed = Duration.between(start, now);
            if (CompareTo.isGreaterThan((Comparable)elapsed, (Object)maxDuration)) {
                condition.getAsBoolean();
                if (cause == null) {
                    Assertions.fail((String)message);
                } else {
                    Assertions.fail((String)message, (Throwable)cause.get());
                }
            }
            try {
                TimeUnit.MILLISECONDS.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                Assertions.fail((String)"test was interrupted", (Throwable)e);
                continue;
            }
            break;
        }
        return;
    }

    public static void assertEventuallyTrue(BooleanSupplier condition, Duration maxDuration, String message) {
        AssertionUtils.assertEventuallyTrue(condition, maxDuration, message, null);
    }

    public static void assertEventuallyFalse(BooleanSupplier condition, Duration maxDuration, String message) {
        AssertionUtils.assertEventuallyTrue(() -> !condition.getAsBoolean(), maxDuration, message);
    }

    public static <T> void assertEventuallyEquals(T expected, Supplier<T> actual, Duration maxDuration, String message) {
        AssertionUtils.assertEventuallyTrue(() -> Objects.equals(expected, actual.get()), maxDuration, message);
    }

    public static void assertEventuallySame(Object expected, Supplier<Object> actual, Duration maxDuration, String message) {
        AssertionUtils.assertEventuallyTrue(() -> expected == actual.get(), maxDuration, message);
    }

    public static void assertEventuallyDoesNotThrow(Runnable operation, Duration maxDuration, String message) {
        ValueReference mostRecentException = new ValueReference();
        AssertionUtils.assertEventuallyTrue(() -> {
            try {
                operation.run();
                return true;
            }
            catch (Throwable e) {
                mostRecentException.setValue((Object)e);
                return false;
            }
        }, maxDuration, message, () -> ((ValueReference)mostRecentException).getValue());
    }

    public static void completeBeforeTimeout(InterruptableRunnable operation, Duration maxDuration, String message) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicBoolean error = new AtomicBoolean();
        ((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent("assertion-utils")).setThreadName("assert-prompt-completion")).setInterruptableRunnable(() -> {
            operation.run();
            latch.countDown();
        })).setExceptionHandler((thread, exception) -> {
            error.set(true);
            exception.printStackTrace();
        })).build(true);
        Assertions.assertFalse((boolean)error.get(), (String)"exception encountered while handling operation");
        boolean completed = latch.await(maxDuration.toMillis(), TimeUnit.MILLISECONDS);
        Assertions.assertTrue((boolean)completed, (String)message);
    }

    public static <T> T completeBeforeTimeout(InterruptableSupplier<T> operation, Duration maxDuration, String message) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicBoolean error = new AtomicBoolean();
        AtomicReference value = new AtomicReference();
        ((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent("assertion-utils")).setThreadName("assert-prompt-completion")).setInterruptableRunnable(() -> {
            value.set(operation.get());
            latch.countDown();
        })).setExceptionHandler((thread, exception) -> {
            error.set(true);
            exception.printStackTrace();
        })).build(true);
        Assertions.assertFalse((boolean)error.get(), (String)"exception encountered while handling operation");
        boolean completed = latch.await(maxDuration.toMillis(), TimeUnit.MILLISECONDS);
        Assertions.assertTrue((boolean)completed, (String)message);
        return (T)value.get();
    }

    public static void throwBeforeTimeout(Class<? extends Throwable> expectedException, Runnable operation, Duration maxDuration, String message) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicBoolean error = new AtomicBoolean();
        ((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent("assertion-utils")).setThreadName("assert-prompt-throw")).setRunnable(() -> {
            Assertions.assertThrows((Class)expectedException, operation::run, (String)message);
            latch.countDown();
        }).setExceptionHandler((thread, exception) -> {
            error.set(true);
            exception.printStackTrace();
        })).build(true);
        Assertions.assertFalse((boolean)error.get(), (String)message);
        boolean completed = latch.await(maxDuration.toMillis(), TimeUnit.MILLISECONDS);
        Assertions.assertTrue((boolean)completed, (String)message);
    }

    public static <T> void assertIteratorEquality(Iterator<T> iteratorA, Iterator<T> iteratorB) {
        int count = 0;
        while (iteratorA.hasNext() && iteratorB.hasNext()) {
            Assertions.assertEquals(iteratorA.next(), iteratorB.next(), (String)("The element at position " + count + " does not match."));
            ++count;
        }
        Assertions.assertFalse((boolean)iteratorA.hasNext(), (String)"iterator A is not depleted");
        Assertions.assertFalse((boolean)iteratorB.hasNext(), (String)"iterator B is not depleted");
    }

    public static void assertApproximatelyEquals(double expected, double actual, double tolerance) {
        Assertions.assertTrue((Math.abs(expected - actual) <= tolerance ? 1 : 0) != 0, (String)("expected: " + expected + ", actual: " + actual));
    }

    public static void assertApproximatelyEquals(double expected, double actual) {
        AssertionUtils.assertApproximatelyEquals(expected, actual, 1.0E-6);
    }
}

