/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.model.sequence.set;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.ToLongFunction;
import org.hiero.consensus.model.sequence.map.SequenceMap;
import org.hiero.consensus.model.sequence.set.SequenceSet;

public abstract class AbstractSequenceSet<T>
implements SequenceSet<T> {
    private final SequenceMap<T, Boolean> map;

    protected AbstractSequenceSet(long lowestAllowedSequenceNumber, int sequenceNumberCapacity, boolean allowExpansion, @NonNull ToLongFunction<T> getSequenceNumberFromEntry) {
        Objects.requireNonNull(getSequenceNumberFromEntry);
        this.map = this.buildMap(lowestAllowedSequenceNumber, sequenceNumberCapacity, allowExpansion, getSequenceNumberFromEntry);
    }

    @NonNull
    protected abstract SequenceMap<T, Boolean> buildMap(long var1, int var3, boolean var4, @NonNull ToLongFunction<T> var5);

    @Override
    public boolean add(@NonNull T element) {
        Objects.requireNonNull(element, "element must not be null");
        return this.map.putIfAbsent(element, true);
    }

    @Override
    public boolean remove(@NonNull T element) {
        Objects.requireNonNull(element, "element must not be null");
        return this.map.remove(element) != null;
    }

    @Override
    public boolean contains(T element) {
        return this.map.containsKey(element);
    }

    @Override
    public void removeSequenceNumber(long sequenceNumber, Consumer<T> removedElementHandler) {
        this.map.removeValuesWithSequenceNumber(sequenceNumber, removedElementHandler == null ? null : (k, v) -> removedElementHandler.accept(k));
    }

    @Override
    public List<T> getEntriesWithSequenceNumber(long sequenceNumber) {
        return this.map.getKeysWithSequenceNumber(sequenceNumber);
    }

    @Override
    public void shiftWindow(long lowestAllowedSequenceNumber, Consumer<T> removedElementHandler) {
        this.map.shiftWindow(lowestAllowedSequenceNumber, removedElementHandler == null ? null : (k, v) -> removedElementHandler.accept(k));
    }

    @Override
    public int getSequenceNumberCapacity() {
        return this.map.getSequenceNumberCapacity();
    }

    @Override
    public int getSize() {
        return this.map.getSize();
    }

    @Override
    public long getFirstSequenceNumberInWindow() {
        return this.map.getFirstSequenceNumberInWindow();
    }

    @Override
    public long getLastSequenceNumberInWindow() {
        return this.map.getLastSequenceNumberInWindow();
    }

    public void clear() {
        this.map.clear();
    }
}

