/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.model.internal.analysis;

import com.swirlds.component.framework.model.internal.analysis.ModelEdge;
import com.swirlds.component.framework.model.internal.analysis.ModelVertex;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CycleFinder {
    private static final Logger logger = LogManager.getLogger(CycleFinder.class);

    private CycleFinder() {
    }

    public static boolean checkForCyclicalBackPressure(@NonNull Collection<ModelVertex> vertices) {
        for (ModelVertex vertex : vertices) {
            if (!CycleFinder.checkForCycleStartingFromVertex(vertex)) continue;
            return true;
        }
        logger.info(LogMarker.STARTUP.getMarker(), "No cyclical back pressure detected in wiring model.");
        return false;
    }

    private static boolean checkForCycleStartingFromVertex(@NonNull ModelVertex start) {
        LinkedList<ModelVertex> stack = new LinkedList<ModelVertex>();
        stack.addLast(start);
        HashSet<ModelVertex> visited = new HashSet<ModelVertex>();
        HashMap<ModelVertex, ModelVertex> parents = new HashMap<ModelVertex, ModelVertex>();
        while (!stack.isEmpty()) {
            ModelVertex parent = (ModelVertex)stack.removeLast();
            for (ModelEdge childEdge : parent.getOutgoingEdges()) {
                if (!childEdge.isInsertionIsBlocking()) continue;
                ModelVertex child = childEdge.getDestination();
                if (child.equals(start)) {
                    parents.put(child, parent);
                    CycleFinder.logCycle(start, parents);
                    return true;
                }
                if (!visited.add(child)) continue;
                stack.addLast(child);
                parents.put(child, parent);
            }
        }
        return false;
    }

    private static void logCycle(@NonNull ModelVertex start, @NonNull Map<ModelVertex, ModelVertex> parents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Cyclical back pressure detected in wiring model. Cycle: ");
        ArrayList<ModelVertex> path = new ArrayList<ModelVertex>();
        path.add(start);
        ModelVertex target = start;
        while (!target.equals(start) || path.size() == 1) {
            target = parents.get(target);
            path.add(target);
        }
        for (int i = path.size() - 1; i >= 0; --i) {
            sb.append(((ModelVertex)path.get(i)).getName());
            if (i <= 0) continue;
            sb.append(" -> ");
        }
        logger.error(LogMarker.EXCEPTION.getMarker(), sb.toString());
    }
}

