/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.linking;

import com.swirlds.platform.event.EventCounter;
import com.swirlds.platform.internal.EventImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.sequence.map.SequenceMap;
import org.hiero.consensus.model.sequence.map.StandardSequenceMap;

public class SimpleLinker {
    private static final int INITIAL_CAPACITY = 1024;
    private final SequenceMap<EventDescriptorWrapper, EventImpl> parentDescriptorMap;
    private final Map<Hash, EventImpl> parentHashMap = new HashMap<Hash, EventImpl>(1024);
    private long nonAncientThreshold = 0L;

    public SimpleLinker() {
        this.parentDescriptorMap = new StandardSequenceMap(0L, 1024, true, EventDescriptorWrapper::birthRound);
    }

    @Nullable
    private EventImpl getParentToLink(@NonNull PlatformEvent child, @Nullable EventDescriptorWrapper parentDescriptor) {
        if (parentDescriptor == null) {
            return null;
        }
        if (parentDescriptor.eventDescriptor().birthRound() < this.nonAncientThreshold) {
            return null;
        }
        EventImpl candidateParent = this.parentHashMap.get(parentDescriptor.hash());
        if (candidateParent == null) {
            return null;
        }
        if (candidateParent.getBirthRound() != parentDescriptor.eventDescriptor().birthRound()) {
            return null;
        }
        Instant parentTimeCreated = candidateParent.getBaseEvent().getTimeCreated();
        Instant childTimeCreated = child.getTimeCreated();
        if (parentDescriptor.creator().equals((Object)child.getDescriptor().creator()) && parentTimeCreated.compareTo(childTimeCreated) >= 0) {
            return null;
        }
        return candidateParent;
    }

    @Nullable
    public EventImpl linkEvent(@NonNull PlatformEvent event) {
        if (event.getBirthRound() < this.nonAncientThreshold) {
            return null;
        }
        EventImpl selfParent = this.getParentToLink(event, event.getSelfParent());
        List otherParents = event.getOtherParents();
        EventImpl otherParent = otherParents.isEmpty() ? null : this.getParentToLink(event, (EventDescriptorWrapper)otherParents.get(0));
        EventImpl linkedEvent = new EventImpl(event, selfParent, otherParent);
        EventCounter.incrementLinkedEventCount();
        EventDescriptorWrapper eventDescriptorWrapper = event.getDescriptor();
        this.parentDescriptorMap.put((Object)eventDescriptorWrapper, (Object)linkedEvent);
        this.parentHashMap.put(eventDescriptorWrapper.hash(), linkedEvent);
        return linkedEvent;
    }

    public void setNonAncientThreshold(long nonAncientThreshold) {
        this.nonAncientThreshold = nonAncientThreshold;
        this.parentDescriptorMap.shiftWindow(nonAncientThreshold, (descriptor, event) -> {
            this.parentHashMap.remove(descriptor.hash());
            event.clear();
        });
    }

    @NonNull
    public List<EventImpl> getNonAncientEvents() {
        return this.parentHashMap.values().stream().toList();
    }

    public void clear() {
        this.parentDescriptorMap.clear();
        this.parentHashMap.clear();
    }
}

