/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.signed;

import com.swirlds.common.formatting.TextTable;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.exceptions.MerkleRouteException;
import com.swirlds.common.merkle.iterators.MerkleIterationOrder;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.utility.EmptyIterator;
import com.swirlds.platform.state.signed.MismatchedNodes;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.Hash;

public final class SignedStateComparison {
    private SignedStateComparison() {
    }

    private static Hash getNodeHash(MerkleNode node) {
        if (node != null) {
            Hash hash = node.getHash();
            if (hash == null) {
                throw new IllegalStateException("Node " + node.getClass().getName() + " at position " + String.valueOf(node.getRoute()) + " is unhashed");
            }
            return hash;
        }
        return Cryptography.NULL_HASH;
    }

    private static MerkleNode getNodeAtRoute(MerkleNode root, MerkleRoute route) {
        try {
            return root.getNodeAtRoute(route);
        }
        catch (MerkleRouteException e) {
            return null;
        }
    }

    private static BiPredicate<MerkleNode, MerkleRoute> buildFilter(MerkleNode rootB) {
        return (nodeA, routeA) -> {
            MerkleNode nodeB = SignedStateComparison.getNodeAtRoute(rootB, routeA);
            return !SignedStateComparison.getNodeHash(nodeA).equals((Object)SignedStateComparison.getNodeHash(nodeB));
        };
    }

    private static Predicate<MerkleInternal> buildDescendantFilter(MerkleNode rootB, boolean deep) {
        return nodeA -> {
            MerkleNode nodeB = SignedStateComparison.getNodeAtRoute(rootB, nodeA.getRoute());
            if (nodeB == null || nodeB.isLeaf()) {
                return false;
            }
            return deep || !SignedStateComparison.getNodeHash((MerkleNode)nodeA).equals((Object)SignedStateComparison.getNodeHash(nodeB));
        };
    }

    private static BiFunction<MerkleNode, MerkleRoute, MismatchedNodes> buildTransformer(MerkleNode rootB) {
        return (nodeA, routeA) -> {
            MerkleNode nodeB = SignedStateComparison.getNodeAtRoute(rootB, routeA);
            return new MismatchedNodes((MerkleNode)nodeA, nodeB);
        };
    }

    public static Iterator<MismatchedNodes> mismatchedNodeIterator(MerkleNode rootA, MerkleNode rootB, boolean deep) {
        if (rootA == null && rootB == null) {
            return new EmptyIterator();
        }
        if (rootA == null) {
            return List.of(new MismatchedNodes(null, rootB)).iterator();
        }
        if (rootB == null) {
            return List.of(new MismatchedNodes(rootA, null)).iterator();
        }
        return rootA.treeIterator().setOrder(MerkleIterationOrder.PRE_ORDERED_DEPTH_FIRST).ignoreNull(false).setFilter(SignedStateComparison.buildFilter(rootB)).setDescendantFilter(SignedStateComparison.buildDescendantFilter(rootB, deep)).transform(SignedStateComparison.buildTransformer(rootB));
    }

    public static void printMismatchedNodes(Iterator<MismatchedNodes> nodeIterator, int limit) {
        if (!nodeIterator.hasNext()) {
            System.out.println("States are identical.");
            return;
        }
        System.out.println("States do not match.\n");
        TextTable table = new TextTable().setBordersEnabled(false).setExtraPadding(3).addRow(new Object[]{"", "", "State A", "State B"});
        int count = 0;
        while (nodeIterator.hasNext() && ++count <= limit) {
            nodeIterator.next().appendNodeDescriptions(table);
        }
        System.out.println(table.render());
        if (nodeIterator.hasNext()) {
            int leftoverNodes = 0;
            while (nodeIterator.hasNext()) {
                nodeIterator.next();
                ++leftoverNodes;
            }
            System.out.println("Maximum number of differences printed. " + leftoverNodes + " difference" + (leftoverNodes == 1 ? "" : "s") + " remain" + (leftoverNodes == 1 ? "s" : "") + ".");
        }
    }
}

