/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime.grpc;

import com.hedera.pbj.runtime.grpc.GrpcStatus;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class GrpcException
extends RuntimeException {
    @NonNull
    private final GrpcStatus status;

    public GrpcException(@NonNull GrpcStatus status) {
        this(status, null, null);
    }

    public GrpcException(@NonNull GrpcStatus status, @Nullable String message) {
        this(status, message, null);
    }

    public GrpcException(@NonNull GrpcStatus status, @Nullable Throwable cause) {
        this(status, null, cause);
    }

    public GrpcException(@NonNull GrpcStatus status, @Nullable String message, @Nullable Throwable cause) {
        super(message, cause);
        this.status = Objects.requireNonNull(status);
        if (status == GrpcStatus.OK) {
            throw new IllegalArgumentException("status cannot be OK");
        }
    }

    @NonNull
    public final GrpcStatus status() {
        return this.status;
    }

    @Override
    @Nullable
    public String getMessage() {
        return super.getMessage();
    }
}

