/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.consensus.framework.validation;

import com.swirlds.platform.test.fixtures.consensus.framework.validation.ConsensusRoundComparisonValidation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.Objects;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.ConsensusRound;

public enum RoundInternalEqualityValidation implements ConsensusRoundComparisonValidation
{
    INSTANCE;


    @Override
    public void validate(@NonNull ConsensusRound round1, @NonNull ConsensusRound round2) {
        long firstRoundNumber = round1.getRoundNum();
        long secondRoundNumber = round2.getRoundNum();
        ((AbstractLongAssert)Assertions.assertThat((long)round1.getRoundNum()).withFailMessage(String.format("round diff at rounds with numbers %d and %d", firstRoundNumber, secondRoundNumber), new Object[0])).isEqualTo(round2.getRoundNum());
        ((AbstractIntegerAssert)Assertions.assertThat((int)round1.getEventCount()).withFailMessage(String.format("event number diff at rounds with numbers %d and %d", firstRoundNumber, secondRoundNumber), new Object[0])).isEqualTo(round2.getEventCount());
        ((ObjectAssert)Assertions.assertThat((Object)round1.getSnapshot()).withFailMessage(String.format("snapshot diff at rounds with numbers %d and %d", firstRoundNumber, secondRoundNumber), new Object[0])).isEqualTo((Object)round2.getSnapshot());
        Iterator evIt1 = round1.getConsensusEvents().iterator();
        Iterator evIt2 = round2.getConsensusEvents().iterator();
        int eventIndex = 0;
        while (evIt1.hasNext() && evIt2.hasNext()) {
            PlatformEvent e1 = (PlatformEvent)evIt1.next();
            PlatformEvent e2 = (PlatformEvent)evIt2.next();
            ((ObjectAssert)Assertions.assertThat((Object)e1.getConsensusData()).withFailMessage(String.format("output:1, roundNumberFromFirstNode:%d, roundNumberFromSecondRound:%d, eventIndex%d is not consensus", firstRoundNumber, secondRoundNumber, eventIndex), new Object[0])).isNotNull();
            ((ObjectAssert)Assertions.assertThat((Object)e2.getConsensusData()).withFailMessage(String.format("output:1, roundNumberFromFirstNode:%d, roundNumberFromSecondRound:%d, eventIndex%d is not consensus", firstRoundNumber, secondRoundNumber, eventIndex), new Object[0])).isNotNull();
            RoundInternalEqualityValidation.assertConsensusEvents(String.format("roundNumberFromFirstNode:%d, roundNumberFromSecondRound:%d, event index %d", firstRoundNumber, secondRoundNumber, eventIndex), e1, e2);
            ++eventIndex;
        }
    }

    private static void assertConsensusEvents(String description, PlatformEvent e1, PlatformEvent e2) {
        boolean equal = Objects.equals(e1, e2);
        if (!equal) {
            StringBuilder sb = new StringBuilder();
            sb.append(description).append("\n");
            sb.append("Events are not equal:\n");
            sb.append("Event 1: ").append(e1).append("\n");
            sb.append("Event 2: ").append(e2).append("\n");
            RoundInternalEqualityValidation.getEventDifference(sb, e1, e2);
            throw new RuntimeException(sb.toString());
        }
    }

    private static void getEventDifference(StringBuilder sb, PlatformEvent event1, PlatformEvent event2) {
        RoundInternalEqualityValidation.checkConsensusTimestamp(event1, event2, sb);
        RoundInternalEqualityValidation.checkConsensusOrder(event1, event2, sb);
    }

    private static void checkConsensusOrder(PlatformEvent event1, PlatformEvent event2, StringBuilder sb) {
        if (event1.getConsensusOrder() != event2.getConsensusOrder()) {
            sb.append("   consensus order mismatch: ").append(event1.getConsensusOrder()).append(" vs ").append(event2.getConsensusOrder()).append("\n");
        }
    }

    private static void checkConsensusTimestamp(PlatformEvent event1, PlatformEvent event2, StringBuilder sb) {
        if (!Objects.equals(event1.getConsensusTimestamp(), event2.getConsensusTimestamp())) {
            sb.append("   consensus timestamp mismatch: ").append(event1.getConsensusTimestamp()).append(" vs ").append(event2.getConsensusTimestamp()).append("\n");
        }
    }
}

