/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.test.fixtures;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.merkledb.test.fixtures.ExampleByteArrayVirtualValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Random;
import org.hiero.base.constructable.ConstructableIgnored;

@ConstructableIgnored
public final class ExampleFixedValue
extends ExampleByteArrayVirtualValue {
    public static final ExampleFixedValueCodec CODEC = new ExampleFixedValueCodec();
    public static final int RANDOM_BYTES = 32;
    static final byte[] RANDOM_DATA = new byte[32];
    private final int id;
    private final byte[] data;

    public static int valueToId(Bytes value) {
        return value.getInt(0L);
    }

    public static byte[] valueToData(Bytes value) {
        return value.toByteArray(4, Math.toIntExact(value.length() - 4L));
    }

    public ExampleFixedValue(int id) {
        this.id = id;
        this.data = RANDOM_DATA;
    }

    public ExampleFixedValue(int id, byte[] data) {
        this.id = id;
        this.data = new byte[data.length];
        System.arraycopy(data, 0, this.data, 0, data.length);
    }

    public ExampleFixedValue(ReadableSequentialData in) {
        this.id = in.readInt();
        int len = in.readInt();
        this.data = new byte[len];
        in.readBytes(this.data);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    public int getSizeInBytes() {
        return 8 + this.data.length;
    }

    public void writeTo(WritableSequentialData out) {
        out.writeInt(this.id);
        out.writeInt(this.data.length);
        out.writeBytes(this.data);
    }

    static {
        new Random(12234L).nextBytes(RANDOM_DATA);
    }

    public static class ExampleFixedValueCodec
    implements Codec<ExampleFixedValue> {
        public ExampleFixedValue getDefaultInstance() {
            return null;
        }

        @NonNull
        public ExampleFixedValue parse(@NonNull ReadableSequentialData in, boolean strictMode, boolean parseUnknownFields, int maxDepth) throws ParseException {
            return new ExampleFixedValue(in);
        }

        public void write(@NonNull ExampleFixedValue value, @NonNull WritableSequentialData out) throws IOException {
            value.writeTo(out);
        }

        public int measure(@NonNull ReadableSequentialData in) throws ParseException {
            throw new UnsupportedOperationException("ExampleFixedValueCodec.measure() not implemented");
        }

        public int measureRecord(ExampleFixedValue value) {
            return value.getSizeInBytes();
        }

        public boolean fastEquals(@NonNull ExampleFixedValue value, @NonNull ReadableSequentialData in) throws ParseException {
            ExampleFixedValue other = (ExampleFixedValue)this.parse(in);
            return other.equals(value);
        }
    }
}

