/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;

public class BlockingOutputStream
extends OutputStream {
    private final OutputStream baseStream;
    boolean block;
    private final CountDownLatch latch = new CountDownLatch(1);

    public BlockingOutputStream(OutputStream baseStream) {
        this.baseStream = baseStream;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.block) {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        this.baseStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.block) {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.baseStream.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.baseStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.latch.countDown();
        this.baseStream.close();
    }

    public void blockAllWrites() {
        this.block = true;
    }

    public boolean isClosed() {
        return this.latch.getCount() == 0L;
    }
}

