/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.consensus.framework.validation;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.hiero.consensus.model.event.PlatformEvent;

public class TestFixtureValidationUtils {
    static void assertBaseEventLists(@NonNull String description, @NonNull List<PlatformEvent> l1, @NonNull List<PlatformEvent> l2, boolean shouldBeEqual) {
        if (l1.size() != l2.size()) {
            Assertions.fail((String)String.format("Length of event lists are unequal: %d vs %d", l1.size(), l2.size()));
        }
        for (int index = 0; index < l1.size(); ++index) {
            PlatformEvent e1 = l1.get(index);
            PlatformEvent e2 = l2.get(index);
            boolean equals = e1.equalsGossipedData(e2);
            if (shouldBeEqual && !equals) {
                String sb = description + "\nEvents are not equal:\nEvent 1: " + String.valueOf(e1) + "\nEvent 2: " + String.valueOf(e2) + "\nat index: " + index;
                Assertions.fail((String)sb);
            }
            if (shouldBeEqual || equals) continue;
            return;
        }
        if (!shouldBeEqual) {
            Assertions.fail((String)String.format("Events are added in exactly the same order. Number of events: %d", l1.size()));
        }
    }
}

