/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.wiring;

import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.swirlds.component.framework.component.ComponentWiring;
import com.swirlds.platform.components.consensus.ConsensusEngine;
import com.swirlds.platform.components.consensus.ConsensusEngineOutput;
import com.swirlds.platform.event.branching.BranchDetector;
import com.swirlds.platform.event.branching.BranchReporter;
import com.swirlds.platform.event.deduplication.EventDeduplicator;
import com.swirlds.platform.event.orphan.OrphanBuffer;
import com.swirlds.platform.event.preconsensus.InlinePcesWriter;
import com.swirlds.platform.event.validation.EventSignatureValidator;
import com.swirlds.platform.event.validation.InternalEventValidator;
import com.swirlds.platform.eventhandling.TransactionHandler;
import com.swirlds.platform.eventhandling.TransactionHandlerResult;
import com.swirlds.platform.eventhandling.TransactionPrehandler;
import com.swirlds.platform.state.hasher.StateHasher;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.StateSignatureCollector;
import com.swirlds.platform.system.status.StatusStateMachine;
import com.swirlds.platform.wiring.NoInput;
import com.swirlds.platform.wiring.components.GossipWiring;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import org.hiero.consensus.event.creator.impl.EventCreationManager;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.model.transaction.ScopedSystemTransaction;

public class PlatformCoordinator {
    private final Runnable flushTheEventHasher;
    private final ComponentWiring<InternalEventValidator, PlatformEvent> internalEventValidatorWiring;
    private final ComponentWiring<EventDeduplicator, PlatformEvent> eventDeduplicatorWiring;
    private final ComponentWiring<EventSignatureValidator, PlatformEvent> eventSignatureValidatorWiring;
    private final ComponentWiring<OrphanBuffer, List<PlatformEvent>> orphanBufferWiring;
    private final GossipWiring gossipWiring;
    private final ComponentWiring<ConsensusEngine, ConsensusEngineOutput> consensusEngineWiring;
    private final ComponentWiring<EventCreationManager, PlatformEvent> eventCreationManagerWiring;
    private final ComponentWiring<TransactionPrehandler, Queue<ScopedSystemTransaction<StateSignatureTransaction>>> applicationTransactionPrehandlerWiring;
    private final ComponentWiring<StateSignatureCollector, List<ReservedSignedState>> stateSignatureCollectorWiring;
    private final ComponentWiring<TransactionHandler, TransactionHandlerResult> transactionHandlerWiring;
    private final ComponentWiring<StateHasher, ReservedSignedState> stateHasherWiring;
    private final ComponentWiring<StatusStateMachine, PlatformStatus> statusStateMachineWiring;
    private final ComponentWiring<BranchDetector, PlatformEvent> branchDetectorWiring;
    private final ComponentWiring<BranchReporter, Void> branchReporterWiring;
    private final ComponentWiring<InlinePcesWriter, PlatformEvent> pcesInlineWriterWiring;

    public PlatformCoordinator(@NonNull Runnable flushTheEventHasher, @NonNull ComponentWiring<InternalEventValidator, PlatformEvent> internalEventValidatorWiring, @NonNull ComponentWiring<EventDeduplicator, PlatformEvent> eventDeduplicatorWiring, @NonNull ComponentWiring<EventSignatureValidator, PlatformEvent> eventSignatureValidatorWiring, @NonNull ComponentWiring<OrphanBuffer, List<PlatformEvent>> orphanBufferWiring, @NonNull GossipWiring gossipWiring, @NonNull ComponentWiring<ConsensusEngine, ConsensusEngineOutput> consensusEngineWiring, @NonNull ComponentWiring<EventCreationManager, PlatformEvent> eventCreationManagerWiring, @NonNull ComponentWiring<TransactionPrehandler, Queue<ScopedSystemTransaction<StateSignatureTransaction>>> applicationTransactionPrehandlerWiring, @NonNull ComponentWiring<StateSignatureCollector, List<ReservedSignedState>> stateSignatureCollectorWiring, @NonNull ComponentWiring<TransactionHandler, TransactionHandlerResult> transactionHandlerWiring, @NonNull ComponentWiring<StateHasher, ReservedSignedState> stateHasherWiring, @NonNull ComponentWiring<StatusStateMachine, PlatformStatus> statusStateMachineWiring, @NonNull ComponentWiring<BranchDetector, PlatformEvent> branchDetectorWiring, @NonNull ComponentWiring<BranchReporter, Void> branchReporterWiring, @Nullable ComponentWiring<InlinePcesWriter, PlatformEvent> pcesInlineWriterWiring) {
        this.flushTheEventHasher = Objects.requireNonNull(flushTheEventHasher);
        this.internalEventValidatorWiring = Objects.requireNonNull(internalEventValidatorWiring);
        this.eventDeduplicatorWiring = Objects.requireNonNull(eventDeduplicatorWiring);
        this.eventSignatureValidatorWiring = Objects.requireNonNull(eventSignatureValidatorWiring);
        this.orphanBufferWiring = Objects.requireNonNull(orphanBufferWiring);
        this.gossipWiring = Objects.requireNonNull(gossipWiring);
        this.consensusEngineWiring = Objects.requireNonNull(consensusEngineWiring);
        this.eventCreationManagerWiring = Objects.requireNonNull(eventCreationManagerWiring);
        this.applicationTransactionPrehandlerWiring = Objects.requireNonNull(applicationTransactionPrehandlerWiring);
        this.stateSignatureCollectorWiring = Objects.requireNonNull(stateSignatureCollectorWiring);
        this.transactionHandlerWiring = Objects.requireNonNull(transactionHandlerWiring);
        this.stateHasherWiring = Objects.requireNonNull(stateHasherWiring);
        this.statusStateMachineWiring = Objects.requireNonNull(statusStateMachineWiring);
        this.branchDetectorWiring = Objects.requireNonNull(branchDetectorWiring);
        this.branchReporterWiring = Objects.requireNonNull(branchReporterWiring);
        this.pcesInlineWriterWiring = pcesInlineWriterWiring;
    }

    public void flushIntakePipeline() {
        this.flushTheEventHasher.run();
        this.internalEventValidatorWiring.flush();
        this.eventDeduplicatorWiring.flush();
        this.eventSignatureValidatorWiring.flush();
        this.orphanBufferWiring.flush();
        if (this.pcesInlineWriterWiring != null) {
            this.pcesInlineWriterWiring.flush();
        }
        this.gossipWiring.flush();
        this.consensusEngineWiring.flush();
        this.applicationTransactionPrehandlerWiring.flush();
        this.eventCreationManagerWiring.flush();
        this.branchDetectorWiring.flush();
    }

    public void clear() {
        this.statusStateMachineWiring.flush();
        this.consensusEngineWiring.startSquelching();
        this.consensusEngineWiring.flush();
        this.eventCreationManagerWiring.startSquelching();
        this.eventCreationManagerWiring.flush();
        this.transactionHandlerWiring.startSquelching();
        this.transactionHandlerWiring.flush();
        this.flushIntakePipeline();
        this.stateHasherWiring.flush();
        this.stateSignatureCollectorWiring.flush();
        this.transactionHandlerWiring.flush();
        this.branchDetectorWiring.flush();
        this.branchReporterWiring.flush();
        this.consensusEngineWiring.stopSquelching();
        this.eventCreationManagerWiring.stopSquelching();
        this.transactionHandlerWiring.stopSquelching();
        this.eventDeduplicatorWiring.getInputWire(EventDeduplicator::clear).inject((Object)NoInput.getInstance());
        this.orphanBufferWiring.getInputWire(OrphanBuffer::clear).inject((Object)NoInput.getInstance());
        this.gossipWiring.getClearInput().inject((Object)NoInput.getInstance());
        this.stateSignatureCollectorWiring.getInputWire(StateSignatureCollector::clear).inject((Object)NoInput.getInstance());
        this.eventCreationManagerWiring.getInputWire(EventCreationManager::clear).inject((Object)NoInput.getInstance());
        this.branchDetectorWiring.getInputWire(BranchDetector::clear).inject((Object)NoInput.getInstance());
        this.branchReporterWiring.getInputWire(BranchReporter::clear).inject((Object)NoInput.getInstance());
    }
}

