/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures;

import com.swirlds.common.test.fixtures.Randotron;
import com.swirlds.common.test.fixtures.WeightGenerator;
import java.util.ArrayList;
import java.util.List;

public class GaussianWeightGenerator
implements WeightGenerator {
    private final long averageWeight;
    private final long weightStandardDeviation;

    public GaussianWeightGenerator(long averageWeight, long weightStandardDeviation) {
        this.averageWeight = averageWeight;
        this.weightStandardDeviation = weightStandardDeviation;
    }

    @Override
    public List<Long> getWeights(long seed, int numberOfNodes) {
        Randotron r = Randotron.create(seed);
        ArrayList<Long> nodeWeights = new ArrayList<Long>(numberOfNodes);
        for (int i = 0; i < numberOfNodes; ++i) {
            nodeWeights.add(Math.max(0L, (long)((double)this.averageWeight + r.nextGaussian() * (double)this.weightStandardDeviation)));
        }
        return nodeWeights;
    }
}

