/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.extensions;

import com.swirlds.base.internal.BaseExecutorFactory;
import com.swirlds.base.internal.observe.BaseExecutorObserver;
import com.swirlds.base.internal.observe.BaseTaskDefinition;
import com.swirlds.metrics.api.Counter;
import com.swirlds.metrics.api.DoubleGauge;
import com.swirlds.metrics.api.LongGauge;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;

public class BaseExecutorFactoryMetrics {
    public static final String BASE_EXECUTOR = "base_executor";
    private final TaskExecutionTimeMetric taskExecutionTimeMetric;
    private final TaskExecutionTimeMetric taskDoneExecutionTimeMetric;
    private final TaskExecutionTimeMetric taskFailExecutionTimeMetric;
    private final Counter taskCountAccumulator;
    private final Counter taskExecutionCountAccumulator;
    private final Counter tasksDoneCountAccumulator;
    private final Counter tasksFailedCountAccumulator;

    public BaseExecutorFactoryMetrics(@NonNull Metrics metrics) {
        Objects.requireNonNull(metrics, "metrics must not be null");
        Counter.Config taskCountAccumulatorConfig = new Counter.Config(BASE_EXECUTOR, "count").withUnit("tasks").withDescription("The number of tasks submitted to the base executor");
        this.taskCountAccumulator = (Counter)metrics.getOrCreate((MetricConfig)taskCountAccumulatorConfig);
        Counter.Config taskExecutionCountAccumulatorConfig = new Counter.Config(BASE_EXECUTOR, "execution_count").withUnit("tasks").withDescription("The number of tasks executed by the base executor");
        this.taskExecutionCountAccumulator = (Counter)metrics.getOrCreate((MetricConfig)taskExecutionCountAccumulatorConfig);
        Counter.Config tasksDoneCountAccumulatorConfig = new Counter.Config(BASE_EXECUTOR, "done_count").withUnit("tasks").withDescription("The number of tasks executed successfully by the base executor");
        this.tasksDoneCountAccumulator = (Counter)metrics.getOrCreate((MetricConfig)tasksDoneCountAccumulatorConfig);
        Counter.Config tasksFailedCountAccumulatorConfig = new Counter.Config(BASE_EXECUTOR, "failed_count").withUnit("tasks").withDescription("The number of tasks failed to execute by the base executor");
        this.tasksFailedCountAccumulator = (Counter)metrics.getOrCreate((MetricConfig)tasksFailedCountAccumulatorConfig);
        this.taskExecutionTimeMetric = new TaskExecutionTimeMetric(this, BASE_EXECUTOR, "task_execution", metrics);
        this.taskDoneExecutionTimeMetric = new TaskExecutionTimeMetric(this, BASE_EXECUTOR, "task_done_execution", metrics);
        this.taskFailExecutionTimeMetric = new TaskExecutionTimeMetric(this, BASE_EXECUTOR, "task_failed_execution", metrics);
        BaseExecutorObserver observer = new BaseExecutorObserver(){

            public void onTaskSubmitted(@NonNull BaseTaskDefinition taskDefinition) {
                BaseExecutorFactoryMetrics.this.taskCountAccumulator.increment();
            }

            public void onTaskStarted(@NonNull BaseTaskDefinition taskDefinition) {
                BaseExecutorFactoryMetrics.this.taskExecutionCountAccumulator.increment();
            }

            public void onTaskDone(@NonNull BaseTaskDefinition taskDefinition, @NonNull Duration duration) {
                BaseExecutorFactoryMetrics.this.tasksDoneCountAccumulator.increment();
                BaseExecutorFactoryMetrics.this.taskExecutionTimeMetric.update(duration);
                BaseExecutorFactoryMetrics.this.taskDoneExecutionTimeMetric.update(duration);
            }

            public void onTaskFailed(@NonNull BaseTaskDefinition taskDefinition, @NonNull Duration duration) {
                BaseExecutorFactoryMetrics.this.tasksFailedCountAccumulator.increment();
                BaseExecutorFactoryMetrics.this.taskExecutionTimeMetric.update(duration);
                BaseExecutorFactoryMetrics.this.taskFailExecutionTimeMetric.update(duration);
            }
        };
        BaseExecutorFactory.addObserver((BaseExecutorObserver)observer);
    }

    public void reset() {
        Optional.ofNullable(this.taskExecutionTimeMetric).ifPresent(TaskExecutionTimeMetric::reset);
        Optional.ofNullable(this.taskDoneExecutionTimeMetric).ifPresent(TaskExecutionTimeMetric::reset);
        Optional.ofNullable(this.taskFailExecutionTimeMetric).ifPresent(TaskExecutionTimeMetric::reset);
        Optional.ofNullable(this.taskCountAccumulator).ifPresent(Metric::reset);
        Optional.ofNullable(this.taskExecutionCountAccumulator).ifPresent(Metric::reset);
        Optional.ofNullable(this.tasksDoneCountAccumulator).ifPresent(Metric::reset);
        Optional.ofNullable(this.tasksFailedCountAccumulator).ifPresent(Metric::reset);
    }

    private class TaskExecutionTimeMetric {
        private final AtomicLong callCount = new AtomicLong(0L);
        private final LongGauge maxMillisMetric;
        private final LongGauge minMillisMetric;
        private final DoubleGauge averageMillisMetric;

        public TaskExecutionTimeMetric(BaseExecutorFactoryMetrics baseExecutorFactoryMetrics, String category, @NonNull String name, Metrics metrics) {
            LongGauge.Config maxMillisConfig = new LongGauge.Config(BaseExecutorFactoryMetrics.BASE_EXECUTOR, name + "_max").withDescription("The maximum time in milliseconds that a task took to execute").withUnit("ms").withInitialValue(0L);
            this.maxMillisMetric = (LongGauge)metrics.getOrCreate((MetricConfig)maxMillisConfig);
            LongGauge.Config minMillisConfig = new LongGauge.Config(BaseExecutorFactoryMetrics.BASE_EXECUTOR, name + "_min").withDescription("The minimum time in milliseconds that a task took to execute").withUnit("ms").withInitialValue(0L);
            this.minMillisMetric = (LongGauge)metrics.getOrCreate((MetricConfig)minMillisConfig);
            DoubleGauge.Config averageMillisConfig = new DoubleGauge.Config(BaseExecutorFactoryMetrics.BASE_EXECUTOR, name + "_avg").withDescription("The average time in milliseconds that a task took to execute").withUnit("ms").withInitialValue(Double.NaN);
            this.averageMillisMetric = (DoubleGauge)metrics.getOrCreate((MetricConfig)averageMillisConfig);
        }

        public void reset() {
            this.callCount.set(0L);
            this.maxMillisMetric.set(0L);
            this.minMillisMetric.set(0L);
            this.averageMillisMetric.set(Double.NaN);
        }

        public void update(@NonNull Duration duration) {
            Objects.requireNonNull(duration, "duration must not be null");
            long prefCount = this.callCount.getAndIncrement();
            long millis = duration.toMillis();
            this.maxMillisMetric.set(Math.max(this.maxMillisMetric.get(), millis));
            this.minMillisMetric.set(Math.min(this.minMillisMetric.get(), millis));
            if (Double.isNaN(this.averageMillisMetric.get())) {
                this.averageMillisMetric.set((double)duration.toMillis());
            }
            try {
                double newAvg = (this.averageMillisMetric.get() * (double)prefCount + (double)duration.toMillis()) / (double)this.callCount.get();
                this.averageMillisMetric.set(newAvg);
            }
            catch (Exception e) {
                this.averageMillisMetric.set(Double.NaN);
            }
        }
    }
}

