/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.impl.converters;

import com.swirlds.config.api.converter.ConfigConverter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DurationConverter
implements ConfigConverter<Duration> {
    private static final Pattern DURATION_REGEX = Pattern.compile("^\\s*(\\d*\\.?\\d*)\\s*([a-zA-Z]+)\\s*$");
    private static final Pattern NUMBER_REGEX = Pattern.compile("\\d+");

    public Duration convert(@NonNull String value) throws IllegalArgumentException {
        return DurationConverter.parseDuration(value);
    }

    private static Duration parseDuration(String str) {
        Matcher matcher = DURATION_REGEX.matcher(str);
        if (matcher.find()) {
            long toNanoseconds;
            String unit;
            double magnitude = Double.parseDouble(matcher.group(1));
            switch (unit = matcher.group(2).trim().toLowerCase()) {
                case "ns": 
                case "nano": 
                case "nanos": 
                case "nanosecond": 
                case "nanoseconds": 
                case "nanosec": 
                case "nanosecs": {
                    toNanoseconds = 1L;
                    break;
                }
                case "us": 
                case "micro": 
                case "micros": 
                case "microsecond": 
                case "microseconds": 
                case "microsec": 
                case "microsecs": {
                    toNanoseconds = 1000L;
                    break;
                }
                case "ms": 
                case "milli": 
                case "millis": 
                case "millisecond": 
                case "milliseconds": 
                case "millisec": 
                case "millisecs": {
                    toNanoseconds = 1000000L;
                    break;
                }
                case "s": 
                case "second": 
                case "seconds": 
                case "sec": 
                case "secs": {
                    toNanoseconds = 1000000000L;
                    break;
                }
                case "m": 
                case "minute": 
                case "minutes": 
                case "min": 
                case "mins": {
                    toNanoseconds = 60000000000L;
                    break;
                }
                case "h": 
                case "hour": 
                case "hours": {
                    toNanoseconds = 3600000000000L;
                    break;
                }
                case "d": 
                case "day": 
                case "days": {
                    toNanoseconds = 86400000000000L;
                    break;
                }
                case "w": 
                case "week": 
                case "weeks": {
                    toNanoseconds = 604800000000000L;
                    break;
                }
                default: {
                    Duration duration = DurationConverter.attemptDefaultDurationDeserialization(str);
                    if (duration == null) {
                        throw new IllegalArgumentException("Invalid duration format, unrecognized unit \"" + unit + "\"");
                    }
                    return duration;
                }
            }
            double totalNanoseconds = magnitude * (double)toNanoseconds;
            if (totalNanoseconds > 9.223372036854776E18) {
                double toSeconds = (double)toNanoseconds * 1.0E-9;
                long seconds = (long)(magnitude * toSeconds);
                return Duration.ofSeconds(seconds);
            }
            return Duration.ofNanos((long)totalNanoseconds);
        }
        Matcher integerMatcher = NUMBER_REGEX.matcher(str);
        if (integerMatcher.matches()) {
            return Duration.ofMillis(Long.parseLong(str));
        }
        Duration duration = DurationConverter.attemptDefaultDurationDeserialization(str);
        if (duration == null) {
            throw new IllegalArgumentException("Invalid duration format, unable to parse \"" + str + "\"");
        }
        return duration;
    }

    private static Duration attemptDefaultDurationDeserialization(String str) {
        try {
            return Duration.parse(str);
        }
        catch (DateTimeParseException ignored) {
            return null;
        }
    }
}

