/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.spi;

import com.swirlds.state.spi.ReadableQueueState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Iterator;
import java.util.Objects;

public abstract class ReadableQueueStateBase<E>
implements ReadableQueueState<E> {
    private E peekedElement;
    protected final String serviceName;
    protected final String stateKey;

    protected ReadableQueueStateBase(@NonNull String serviceName, @NonNull String stateKey) {
        this.serviceName = Objects.requireNonNull(serviceName);
        this.stateKey = Objects.requireNonNull(stateKey);
    }

    @Override
    @NonNull
    public final String getServiceName() {
        return this.serviceName;
    }

    @Override
    @NonNull
    public final String getStateKey() {
        return this.stateKey;
    }

    @Override
    @Nullable
    public E peek() {
        if (this.peekedElement == null) {
            this.peekedElement = this.peekOnDataSource();
        }
        return this.peekedElement;
    }

    @Override
    @NonNull
    public Iterator<E> iterator() {
        return this.iterateOnDataSource();
    }

    @Nullable
    protected abstract E peekOnDataSource();

    @NonNull
    protected abstract Iterator<E> iterateOnDataSource();
}

