/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.config;

import com.swirlds.config.api.ConfigData;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.validation.ConfigViolation;
import com.swirlds.config.extensions.validators.DefaultConfigViolation;

@ConfigData(value="merkleDb")
public record MerkleDbConfig(long initialCapacity, long maxNumOfKeys, long hashesRamToDiskThreshold, int hashStoreRamBufferSize, boolean hashStoreRamOffHeapBuffers, int longListChunkSize, int longListReservedBufferSize, int compactionThreads, int minNumberOfFilesInCompaction, int maxCompactionLevel, int iteratorInputBufferBytes, boolean reconnectKeyLeakMitigationEnabled, boolean indexRebuildingEnforced, int goodAverageBucketEntryCount, String tablesToRepairHdhm, double percentHalfDiskHashMapFlushThreads, int numHalfDiskHashMapFlushThreads, int leafRecordCacheSize, int maxFileChannelsPerFileReader, int maxThreadsPerFileChannel) {
    static double UNIT_FRACTION_PERCENT = 100.0;

    public ConfigViolation minNumberOfFilesInCompactionValidation(Configuration configuration) {
        long minNumberOfFilesInCompaction = ((MerkleDbConfig)configuration.getConfigData(MerkleDbConfig.class)).minNumberOfFilesInCompaction();
        if (minNumberOfFilesInCompaction < 2L) {
            return new DefaultConfigViolation("minNumberOfFilesInCompaction", "%d".formatted(minNumberOfFilesInCompaction), true, "Cannot configure minNumberOfFilesInCompaction to " + minNumberOfFilesInCompaction + ", it must be >= 2");
        }
        return null;
    }

    public int getNumHalfDiskHashMapFlushThreads() {
        int numProcessors = Runtime.getRuntime().availableProcessors();
        int threads = this.numHalfDiskHashMapFlushThreads() == -1 ? (int)((double)numProcessors * (this.percentHalfDiskHashMapFlushThreads() / UNIT_FRACTION_PERCENT)) : this.numHalfDiskHashMapFlushThreads();
        return Math.max(1, threads);
    }
}

