/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.sync;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.test.fixtures.platform.TestPlatformContextBuilder;
import com.swirlds.common.test.fixtures.threading.SyncPhaseParallelExecutor;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.common.threading.pool.ParallelExecutor;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.extensions.test.fixtures.TestConfigBuilder;
import com.swirlds.platform.test.fixtures.sync.SyncNode;
import org.hiero.base.concurrent.ThrowingRunnable;

public class Synchronizer {
    private final ParallelExecutor parallelExecutor = new SyncPhaseParallelExecutor(AdHocThreadManager.getStaticThreadManager(), null, null, false);

    public void synchronize(SyncNode caller, SyncNode listener) throws Exception {
        Configuration configuration = new TestConfigBuilder().withValue("sync.filterLikelyDuplicates", false).withValue("sync.maxSyncEventCount", 0).getOrCreateConfig();
        PlatformContext platformContext = TestPlatformContextBuilder.create().withConfiguration(configuration).build();
        this.parallelExecutor.doParallel(() -> {
            try {
                boolean synchronize = caller.getSynchronizer().synchronize(platformContext, caller.getConnection(), false);
                caller.setSynchronizerReturn(synchronize);
            }
            catch (Exception e) {
                caller.setSynchronizerReturn(null);
                caller.setSyncException(e);
                caller.getConnection().disconnect();
                throw e;
            }
            return null;
        }, new ThrowingRunnable[]{() -> {
            try {
                if (listener.isCanAcceptSync()) {
                    boolean synchronize = listener.getSynchronizer().synchronize(platformContext, listener.getConnection(), false);
                    listener.setSynchronizerReturn(synchronize);
                }
            }
            catch (Exception e) {
                listener.setSynchronizerReturn(null);
                listener.setSyncException(e);
                listener.getConnection().disconnect();
                throw e;
            }
        }});
    }
}

