/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform.nft;

import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.common.metrics.SpeedometerMetric;
import com.swirlds.common.utility.StopWatch;
import com.swirlds.demo.platform.PlatformTestingToolState;
import com.swirlds.demo.platform.nft.Nft;
import com.swirlds.demo.platform.nft.NftId;
import com.swirlds.demo.platform.nft.NftLedger;
import com.swirlds.demo.platform.nft.ReferenceNftLedger;
import com.swirlds.demo.platform.nft.config.NftQueryConfig;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.platform.system.Platform;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NftSimpleQuerier {
    private static final Random RANDOM = new SecureRandom();
    private static final Logger logger = LogManager.getLogger(NftSimpleQuerier.class);
    private static final RunningAverageMetric.Config TOKENS_PER_KEY_CONFIG = new RunningAverageMetric.Config("NFT", "nftTokensPerKey").withDescription("avg number of tokens each key has when queried").withFormat("%,9.6f").withHalfLife(10.0);
    private static RunningAverageMetric tokensPerKey;
    private static final RunningAverageMetric.Config NFT_QUERIES_ANSWERED_MICRO_SEC_CONFIG;
    private static RunningAverageMetric nftQueriesAnsweredMicroSec;
    private static int PAGE_SIZE;

    protected static void registerStats(Platform platform) {
        tokensPerKey = (RunningAverageMetric)platform.getContext().getMetrics().getOrCreate((MetricConfig)TOKENS_PER_KEY_CONFIG);
        nftQueriesAnsweredMicroSec = (RunningAverageMetric)platform.getContext().getMetrics().getOrCreate((MetricConfig)NFT_QUERIES_ANSWERED_MICRO_SEC_CONFIG);
    }

    protected static void setConfig(NftQueryConfig config) {
        if (config.getPageSize() > 0) {
            PAGE_SIZE = config.getPageSize();
        }
    }

    public static void execute(PlatformTestingToolState state, SpeedometerMetric queriesAnswered) {
        Nft referenceToken;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        NftLedger ledger = state.getNftLedger();
        Optional<NftId> nftIdCheck = state.getStateExpectedMap().getAnyNftId();
        if (nftIdCheck.isEmpty()) {
            return;
        }
        NftId nftId = nftIdCheck.get();
        Nft nft = (Nft)ledger.getTokenIdToToken().get((Object)nftId);
        if (nft == null) {
            return;
        }
        MapKey key = nft.getMapKey();
        int totalTokens = ledger.numberOfTokensByAccount(key);
        if (totalTokens < 1) {
            return;
        }
        int limitToQuery = totalTokens - PAGE_SIZE < 1 ? totalTokens : totalTokens - PAGE_SIZE;
        int startIndex = RANDOM.nextInt(limitToQuery);
        int limit = Math.min(startIndex + PAGE_SIZE, totalTokens);
        ledger.getTokensByAccount(key, startIndex, limit);
        ReferenceNftLedger referenceNftLedger = state.getReferenceNftLedger();
        if (referenceNftLedger.isTokenTracked(nftId) && !Objects.equals((Object)(referenceToken = referenceNftLedger.getTokenMap().get(nftId)), (Object)nft)) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "reference token " + String.valueOf((Object)referenceToken) + " does not match token in state " + String.valueOf((Object)nft));
        }
        stopWatch.stop();
        nftQueriesAnsweredMicroSec.update((double)stopWatch.getTime(TimeUnit.MICROSECONDS));
        tokensPerKey.update((double)totalTokens);
        queriesAnswered.update(1.0);
    }

    static {
        NFT_QUERIES_ANSWERED_MICRO_SEC_CONFIG = new RunningAverageMetric.Config("NFT", "nftQueriesAnsweredMicroSec").withDescription("avg time taken to answer a query through NftLedger (in microseconds)").withFormat("%,9.6f").withHalfLife(10.0);
        PAGE_SIZE = 5;
    }
}

