/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.service;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.hedera.hapi.platform.state.PlatformState;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.platform.state.PlatformStateModifier;
import com.swirlds.platform.state.service.PbjConverter;
import com.swirlds.platform.state.service.PlatformStateValueAccumulator;
import com.swirlds.platform.state.service.ReadablePlatformStateStore;
import com.swirlds.state.spi.CommittableWritableStates;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Objects;
import java.util.function.Consumer;
import org.hiero.base.crypto.Hash;
import org.hiero.base.utility.CommonUtils;

public class WritablePlatformStateStore
extends ReadablePlatformStateStore
implements PlatformStateModifier {
    private final WritableStates writableStates;
    private final WritableSingletonState<PlatformState> state;

    public WritablePlatformStateStore(@NonNull WritableStates writableStates) {
        super((ReadableStates)writableStates);
        this.writableStates = writableStates;
        this.state = writableStates.getSingleton("PLATFORM_STATE");
    }

    public void setAllFrom(@NonNull PlatformStateModifier modifier) {
        this.update(PbjConverter.toPbjPlatformState(modifier));
    }

    private void setAllFrom(@NonNull PlatformStateValueAccumulator accumulator) {
        this.update(PbjConverter.toPbjPlatformState(this.stateOrThrow(), accumulator));
    }

    @Override
    public void setCreationSoftwareVersion(@NonNull SemanticVersion creationVersion) {
        Objects.requireNonNull(creationVersion);
        PlatformState previousState = this.stateOrThrow();
        this.update(previousState.copyBuilder().creationSoftwareVersion(creationVersion));
    }

    @Override
    public void setRound(long round) {
        PlatformState previousState = this.stateOrThrow();
        this.update(previousState.copyBuilder().consensusSnapshot(previousState.consensusSnapshotOrElse(ConsensusSnapshot.DEFAULT).copyBuilder().round(round)));
    }

    @Override
    public void setLegacyRunningEventHash(@Nullable Hash legacyRunningEventHash) {
        PlatformState previousState = this.stateOrThrow();
        this.update(previousState.copyBuilder().legacyRunningEventHash(legacyRunningEventHash == null ? Bytes.EMPTY : legacyRunningEventHash.getBytes()));
    }

    @Override
    public void setConsensusTimestamp(@NonNull Instant consensusTimestamp) {
        Objects.requireNonNull(consensusTimestamp);
        PlatformState previousState = this.stateOrThrow();
        this.update(previousState.copyBuilder().consensusSnapshot(previousState.consensusSnapshotOrElse(ConsensusSnapshot.DEFAULT).copyBuilder().consensusTimestamp(CommonUtils.toPbjTimestamp((Instant)consensusTimestamp))));
    }

    @Override
    public void setRoundsNonAncient(int roundsNonAncient) {
        PlatformState previousState = this.stateOrThrow();
        this.update(previousState.copyBuilder().roundsNonAncient(roundsNonAncient));
    }

    @Override
    public void setSnapshot(@NonNull ConsensusSnapshot snapshot) {
        Objects.requireNonNull(snapshot);
        PlatformState previousState = this.stateOrThrow();
        this.update(previousState.copyBuilder().consensusSnapshot(snapshot));
    }

    @Override
    public void setFreezeTime(@Nullable Instant freezeTime) {
        PlatformState previousState = this.stateOrThrow();
        this.update(previousState.copyBuilder().freezeTime(CommonUtils.toPbjTimestamp((Instant)freezeTime)));
    }

    @Override
    public void setLastFrozenTime(@Nullable Instant lastFrozenTime) {
        PlatformState previousState = this.stateOrThrow();
        this.update(previousState.copyBuilder().lastFrozenTime(CommonUtils.toPbjTimestamp((Instant)lastFrozenTime)));
    }

    @Override
    public void setLatestFreezeRound(long latestFreezeRound) {
        PlatformState previousState = this.stateOrThrow();
        this.update(previousState.copyBuilder().latestFreezeRound(latestFreezeRound));
    }

    @Override
    public void bulkUpdate(@NonNull Consumer<PlatformStateModifier> updater) {
        PlatformStateValueAccumulator accumulator = new PlatformStateValueAccumulator();
        updater.accept(accumulator);
        this.setAllFrom(accumulator);
    }

    @NonNull
    private PlatformState stateOrThrow() {
        return Objects.requireNonNull((PlatformState)this.state.get());
    }

    private void update(@NonNull PlatformState.Builder stateBuilder) {
        this.update(stateBuilder.build());
    }

    private void update(@NonNull PlatformState stateBuilder) {
        this.state.put((Object)stateBuilder);
        WritableStates writableStates = this.writableStates;
        if (writableStates instanceof CommittableWritableStates) {
            CommittableWritableStates committableWritableStates = (CommittableWritableStates)writableStates;
            committableWritableStates.commit();
        }
    }
}

