/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.codec.TokenTransferListJsonCodec;
import com.hedera.hapi.node.base.codec.TokenTransferListProtoCodec;
import com.hedera.hapi.node.base.schema.TokenTransferListSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class TokenTransferList {
    public static final Codec<TokenTransferList> PROTOBUF = new TokenTransferListProtoCodec();
    public static final JsonCodec<TokenTransferList> JSON = new TokenTransferListJsonCodec();
    public static final TokenTransferList DEFAULT = TokenTransferList.newBuilder().build();
    @Nullable
    private final TokenID token;
    @NonNull
    private final List<AccountAmount> transfers;
    @NonNull
    private final List<NftTransfer> nftTransfers;
    @Nullable
    private final Integer expectedDecimals;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public TokenTransferList(TokenID token, List<AccountAmount> transfers, List<NftTransfer> nftTransfers, Integer expectedDecimals) {
        this.$unknownFields = null;
        this.token = token;
        this.transfers = transfers == null ? Collections.emptyList() : transfers;
        this.nftTransfers = nftTransfers == null ? Collections.emptyList() : nftTransfers;
        this.expectedDecimals = expectedDecimals;
    }

    public TokenTransferList(TokenID token, List<AccountAmount> transfers, List<NftTransfer> nftTransfers, Integer expectedDecimals, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.token = token;
        this.transfers = transfers == null ? Collections.emptyList() : transfers;
        this.nftTransfers = nftTransfers == null ? Collections.emptyList() : nftTransfers;
        this.expectedDecimals = expectedDecimals;
    }

    public TokenID token() {
        return this.token;
    }

    public List<AccountAmount> transfers() {
        return this.transfers;
    }

    public List<NftTransfer> nftTransfers() {
        return this.nftTransfers;
    }

    public Integer expectedDecimals() {
        return this.expectedDecimals;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenTransferListSchema.TOKEN, (Object)this.token, TokenID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TokenTransferListSchema.TRANSFERS, this.transfers, AccountAmount.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TokenTransferListSchema.NFT_TRANSFERS, this.nftTransfers, NftTransfer.PROTOBUF);
            _size += ProtoWriterTools.sizeOfOptionalInteger((FieldDefinition)TokenTransferListSchema.EXPECTED_DECIMALS, (Integer)this.expectedDecimals);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        if (this.$hashCode == -1) {
            List<NftTransfer> list$nftTransfers;
            List<AccountAmount> list$transfers;
            int result = 1;
            if (this.token != null && !this.token.equals(TokenTransferList.DEFAULT.token)) {
                result = 31 * result + this.token.hashCode();
            }
            if ((list$transfers = this.transfers) != null) {
                for (AccountAmount accountAmount : list$transfers) {
                    if (accountAmount != null) {
                        result = 31 * result + ((Object)accountAmount).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if ((list$nftTransfers = this.nftTransfers) != null) {
                for (NftTransfer nftTransfer : list$nftTransfers) {
                    if (nftTransfer != null) {
                        result = 31 * result + ((Object)nftTransfer).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.expectedDecimals != null && !this.expectedDecimals.equals(TokenTransferList.DEFAULT.expectedDecimals)) {
                result = 31 * result + Integer.hashCode(this.expectedDecimals);
            }
            if (this.$unknownFields != null) {
                void var4_8;
                boolean bl = false;
                while (var4_8 < this.$unknownFields.size()) {
                    result = 31 * result + this.$unknownFields.get((int)var4_8).hashCode();
                    ++var4_8;
                }
            }
            long l = result;
            l += l << 30;
            l ^= l >>> 27;
            l += l << 16;
            l ^= l >>> 20;
            l += l << 5;
            l ^= l >>> 18;
            l += l << 10;
            l ^= l >>> 24;
            l += l << 30;
            this.$hashCode = (int)l;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TokenTransferList thatObj = (TokenTransferList)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.token == null && thatObj.token != null) {
            return false;
        }
        if (this.token != null && !this.token.equals(thatObj.token)) {
            return false;
        }
        if (this.transfers == null && thatObj.transfers != null) {
            return false;
        }
        if (this.transfers != null && !this.transfers.equals(thatObj.transfers)) {
            return false;
        }
        if (this.nftTransfers == null && thatObj.nftTransfers != null) {
            return false;
        }
        if (this.nftTransfers != null && !this.nftTransfers.equals(thatObj.nftTransfers)) {
            return false;
        }
        if (this.expectedDecimals == null && thatObj.expectedDecimals != null) {
            return false;
        }
        if (this.expectedDecimals != null && !this.expectedDecimals.equals(thatObj.expectedDecimals)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "TokenTransferList[token=" + String.valueOf(this.token) + ", transfers=" + String.valueOf(this.transfers) + ", nftTransfers=" + String.valueOf(this.nftTransfers) + ", expectedDecimals=" + this.expectedDecimals + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasToken() {
        return this.token != null;
    }

    public TokenID tokenOrElse(@NonNull TokenID defaultValue) {
        return this.hasToken() ? this.token : defaultValue;
    }

    @NonNull
    public TokenID tokenOrThrow() {
        return Objects.requireNonNull(this.token, "Field token is null");
    }

    public void ifToken(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasToken()) {
            ifPresent.accept(this.token);
        }
    }

    public boolean hasExpectedDecimals() {
        return this.expectedDecimals != null;
    }

    public Integer expectedDecimalsOrElse(@NonNull Integer defaultValue) {
        return this.hasExpectedDecimals() ? this.expectedDecimals : defaultValue;
    }

    @NonNull
    public Integer expectedDecimalsOrThrow() {
        return Objects.requireNonNull(this.expectedDecimals, "Field expectedDecimals is null");
    }

    public void ifExpectedDecimals(@NonNull Consumer<Integer> ifPresent) {
        if (this.hasExpectedDecimals()) {
            ifPresent.accept(this.expectedDecimals);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.token, this.transfers, this.nftTransfers, this.expectedDecimals, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private TokenID token = null;
        @NonNull
        private List<AccountAmount> transfers = Collections.emptyList();
        @NonNull
        private List<NftTransfer> nftTransfers = Collections.emptyList();
        @Nullable
        private Integer expectedDecimals = null;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(TokenID token, List<AccountAmount> transfers, List<NftTransfer> nftTransfers, Integer expectedDecimals) {
            this.$unknownFields = null;
            this.token = token;
            this.transfers = transfers == null ? Collections.emptyList() : transfers;
            this.nftTransfers = nftTransfers == null ? Collections.emptyList() : nftTransfers;
            this.expectedDecimals = expectedDecimals;
        }

        public Builder(TokenID token, List<AccountAmount> transfers, List<NftTransfer> nftTransfers, Integer expectedDecimals, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.token = token;
            this.transfers = transfers == null ? Collections.emptyList() : transfers;
            this.nftTransfers = nftTransfers == null ? Collections.emptyList() : nftTransfers;
            this.expectedDecimals = expectedDecimals;
        }

        public TokenTransferList build() {
            return new TokenTransferList(this.token, this.transfers, this.nftTransfers, this.expectedDecimals);
        }

        public Builder token(@Nullable TokenID token) {
            this.token = token;
            return this;
        }

        public Builder token(TokenID.Builder builder) {
            this.token = builder.build();
            return this;
        }

        public Builder transfers(@NonNull List<AccountAmount> transfers) {
            this.transfers = transfers != null ? transfers : Collections.emptyList();
            return this;
        }

        public Builder transfers(AccountAmount ... values) {
            this.transfers = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder nftTransfers(@NonNull List<NftTransfer> nftTransfers) {
            this.nftTransfers = nftTransfers != null ? nftTransfers : Collections.emptyList();
            return this;
        }

        public Builder nftTransfers(NftTransfer ... values) {
            this.nftTransfers = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder expectedDecimals(@Nullable Integer expectedDecimals) {
            this.expectedDecimals = expectedDecimals;
            return this;
        }
    }
}

