/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.roster;

import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterState;
import com.hedera.hapi.node.state.roster.RoundRosterPair;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.hedera.hapi.platform.state.PlatformState;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.State;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import org.hiero.consensus.roster.RosterUtils;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public final class RosterServiceStateMock {
    private RosterServiceStateMock() {
    }

    public static void setup(State stateMock, Roster currentRoster) {
        RosterServiceStateMock.setup(stateMock, currentRoster, 0L, null);
    }

    public static void setup(@NonNull State stateMock, @Nullable Roster currentRoster, long round, @Nullable Roster previousRoster) {
        ProtoBytes value;
        ReadableStates readableStates = (ReadableStates)Mockito.mock(ReadableStates.class);
        Mockito.when((Object)stateMock.getReadableStates("RosterService")).thenReturn((Object)readableStates);
        ReadableKVState rosterMap = (ReadableKVState)Mockito.mock(ReadableKVState.class);
        Mockito.when((Object)readableStates.get("ROSTERS")).thenReturn((Object)rosterMap);
        ArrayList<RoundRosterPair> roundRosterPairs = new ArrayList<RoundRosterPair>();
        if (currentRoster != null) {
            Bytes rosterHash = RosterUtils.hash((Roster)currentRoster).getBytes();
            value = new ProtoBytes(rosterHash);
            Mockito.when((Object)((Roster)rosterMap.get((Object)((ProtoBytes)ArgumentMatchers.eq((Object)value))))).thenReturn((Object)currentRoster);
            Mockito.when((Object)rosterMap.contains((Object)((ProtoBytes)ArgumentMatchers.eq((Object)value)))).thenReturn((Object)true);
            roundRosterPairs.add(new RoundRosterPair(round, rosterHash));
        }
        if (previousRoster != null) {
            if (round <= 0L) {
                throw new IllegalArgumentException("With a non-null previousRoster, the round number for the currentRoster must be greater than zero: previousRoster=" + Roster.JSON.toJSON((Object)previousRoster));
            }
            Bytes previousRosterHash = RosterUtils.hash((Roster)previousRoster).getBytes();
            value = new ProtoBytes(previousRosterHash);
            Mockito.when((Object)((Roster)rosterMap.get((Object)((ProtoBytes)ArgumentMatchers.eq((Object)value))))).thenReturn((Object)previousRoster);
            Mockito.when((Object)rosterMap.contains((Object)((ProtoBytes)ArgumentMatchers.eq((Object)value)))).thenReturn((Object)true);
            roundRosterPairs.add(new RoundRosterPair(0L, previousRosterHash));
        }
        RosterState rosterState = new RosterState(Bytes.EMPTY, roundRosterPairs, false);
        ReadableSingletonState rosterReadableState = (ReadableSingletonState)Mockito.mock(ReadableSingletonState.class);
        Mockito.when((Object)readableStates.getSingleton("ROSTER_STATE")).thenReturn((Object)rosterReadableState);
        Mockito.when((Object)((RosterState)rosterReadableState.get())).thenReturn((Object)rosterState);
        ReadableSingletonState platformReadableState = (ReadableSingletonState)Mockito.mock(ReadableSingletonState.class);
        PlatformState platformState = (PlatformState)Mockito.mock(PlatformState.class);
        Mockito.when((Object)stateMock.getReadableStates("PlatformStateService")).thenReturn((Object)readableStates);
        Mockito.when((Object)readableStates.getSingleton("PLATFORM_STATE")).thenReturn((Object)platformReadableState);
        Mockito.when((Object)((PlatformState)platformReadableState.get())).thenReturn((Object)platformState);
        ConsensusSnapshot consensusSnapshot = (ConsensusSnapshot)Mockito.mock(ConsensusSnapshot.class);
        Mockito.when((Object)consensusSnapshot.round()).thenReturn((Object)round);
        Mockito.when((Object)platformState.consensusSnapshot()).thenReturn((Object)consensusSnapshot);
    }
}

