/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.proof.tree;

import com.swirlds.platform.proof.tree.AbstractStateProofNode;
import com.swirlds.platform.proof.tree.StateProofNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class StateProofInternalNode
extends AbstractStateProofNode {
    private List<StateProofNode> children;
    private boolean visited = false;

    public StateProofInternalNode() {
    }

    public StateProofInternalNode(@NonNull List<StateProofNode> children) {
        this.children = Objects.requireNonNull(children);
    }

    @Override
    public void computeHashableBytes(@NonNull MessageDigest digest) {
        if (this.children == null) {
            throw new IllegalStateException("StateProofInternalNode has not been properly initialized");
        }
        for (StateProofNode child : this.children) {
            digest.update(child.getHashableBytes());
        }
        this.setHashableBytes(digest.digest());
        digest.reset();
    }

    @NonNull
    public List<StateProofNode> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<StateProofNode>();
        }
        return this.children;
    }

    public void markAsVisited() {
        if (this.visited) {
            throw new IllegalStateException("Node has already been visited");
        }
        this.visited = true;
    }

    public boolean hasBeenVisited() {
        return this.visited;
    }
}

