/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.communication.multithreaded;

import com.swirlds.platform.gossip.sync.SyncInputStream;
import com.swirlds.platform.gossip.sync.SyncOutputStream;
import com.swirlds.platform.network.Connection;
import java.io.IOException;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicInteger;
import org.hiero.consensus.model.node.NodeId;

public class ExpiringConnection
implements Connection {
    private final Connection connection;
    private final AtomicInteger returnConnectedTimes;

    public ExpiringConnection(Connection connection, int returnConnectedTimes) {
        this.connection = connection;
        this.returnConnectedTimes = new AtomicInteger(returnConnectedTimes);
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    public NodeId getSelfId() {
        return this.connection.getSelfId();
    }

    public NodeId getOtherId() {
        return this.connection.getOtherId();
    }

    public SyncInputStream getDis() {
        return this.connection.getDis();
    }

    public SyncOutputStream getDos() {
        return this.connection.getDos();
    }

    public boolean connected() {
        return this.returnConnectedTimes.getAndDecrement() > 0;
    }

    public int getTimeout() throws SocketException {
        return this.connection.getTimeout();
    }

    public void setTimeout(long timeoutMillis) throws SocketException {
        this.connection.setTimeout(timeoutMillis);
    }

    public void initForSync() throws IOException {
        this.connection.initForSync();
    }

    public boolean isOutbound() {
        return this.connection.isOutbound();
    }

    public String getDescription() {
        return this.connection.getDescription();
    }
}

