/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.consensus;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.platform.test.fixtures.consensus.ConsensusTestParams;
import com.swirlds.platform.test.fixtures.consensus.framework.TestInput;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Random;
import org.assertj.core.api.ThrowingConsumer;

public class ConsensusTestRunner {
    private ConsensusTestParams params;
    private List<PlatformContext> contexts;
    private ThrowingConsumer<TestInput> test;
    private int iterations = 1;
    private int eventsToGenerate = 10000;

    @NonNull
    public static ConsensusTestRunner create() {
        return new ConsensusTestRunner();
    }

    @NonNull
    public ConsensusTestRunner setParams(@NonNull ConsensusTestParams params) {
        this.params = params;
        return this;
    }

    @NonNull
    public ConsensusTestRunner setContexts(@NonNull List<PlatformContext> contexts) {
        this.contexts = contexts;
        return this;
    }

    @NonNull
    public ConsensusTestRunner setTest(@NonNull ThrowingConsumer<TestInput> test) {
        this.test = test;
        return this;
    }

    @NonNull
    public ConsensusTestRunner setIterations(int iterations) {
        this.iterations = iterations;
        return this;
    }

    public void run() {
        for (long seed : this.params.seeds()) {
            this.runWithSeed(seed);
        }
        if (this.params.seeds().length > 0) {
            return;
        }
        for (int i = 0; i < this.iterations; ++i) {
            long seed = new Random().nextLong();
            this.runWithSeed(seed);
        }
    }

    private void runWithSeed(long seed) {
        System.out.println("Running seed: " + seed);
        try {
            for (PlatformContext context : this.contexts) {
                this.test.accept((Object)new TestInput(context, this.params.numNodes(), this.params.weightGenerator(), seed, this.eventsToGenerate));
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

