/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api;

import com.swirlds.logging.api.extensions.emergency.EmergencyLogger;
import com.swirlds.logging.api.extensions.emergency.EmergencyLoggerProvider;
import edu.umd.cs.findbugs.annotations.NonNull;

public enum Level {
    OFF(0),
    ERROR(10),
    WARN(20),
    INFO(30),
    DEBUG(40),
    TRACE(100);

    private static final EmergencyLogger EMERGENCY_LOGGER;
    private final int levelOrdinal;

    private Level(int levelOrdinal) {
        this.levelOrdinal = levelOrdinal;
    }

    public boolean enabledLoggingOfLevel(@NonNull Level level) {
        if (level == null) {
            EMERGENCY_LOGGER.logNPE("level");
            return true;
        }
        return this.levelOrdinal >= level.levelOrdinal && level.levelOrdinal > 0;
    }

    public String nameWithFixedSize() {
        if (this == OFF) {
            return "OFF  ";
        }
        if (this == ERROR) {
            return "ERROR";
        }
        if (this == WARN) {
            return "WARN ";
        }
        if (this == INFO) {
            return "INFO ";
        }
        if (this == DEBUG) {
            return "DEBUG";
        }
        if (this == TRACE) {
            return "TRACE";
        }
        return "     ";
    }

    static {
        EMERGENCY_LOGGER = EmergencyLoggerProvider.getEmergencyLogger();
    }
}

