/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures;

import com.swirlds.common.io.filesystem.FileSystemManager;
import com.swirlds.common.io.utility.FileUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicLong;

public class TestFileSystemManager
implements FileSystemManager {
    private static final String TMP = "tmp";
    private static final String USER = "usr";
    private final Path rootPath;
    private final Path tempPath;
    private final Path userPath;
    private static final AtomicLong TMP_FIELD_INDEX = new AtomicLong(0L);

    public TestFileSystemManager(@NonNull Path rootLocation) {
        this.rootPath = rootLocation.normalize();
        if (Files.notExists(this.rootPath, new LinkOption[0])) {
            FileUtils.rethrowIO(() -> Files.createDirectory(this.rootPath, new FileAttribute[0]));
        }
        this.tempPath = this.rootPath.resolve(TMP);
        this.userPath = this.rootPath.resolve(USER);
        if (Files.notExists(this.userPath, new LinkOption[0])) {
            FileUtils.rethrowIO(() -> Files.createDirectory(this.userPath, new FileAttribute[0]));
        }
        if (Files.notExists(this.tempPath, new LinkOption[0])) {
            FileUtils.rethrowIO(() -> Files.createDirectory(this.tempPath, new FileAttribute[0]));
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> FileUtils.rethrowIO(() -> FileUtils.deleteDirectory((Path)this.rootPath))));
    }

    @NonNull
    public Path resolve(@NonNull Path relativePath) {
        return this.userPath.resolve(relativePath);
    }

    @NonNull
    public Path resolveNewTemp(@Nullable String tag) {
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(System.currentTimeMillis());
        nameBuilder.append(TMP_FIELD_INDEX.getAndIncrement());
        if (tag != null) {
            nameBuilder.append("-");
            nameBuilder.append(tag);
        }
        return this.tempPath.resolve(nameBuilder.toString());
    }
}

