/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.preconsensus;

import com.hedera.hapi.platform.event.GossipEvent;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.swirlds.platform.event.preconsensus.PcesFileWriter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import org.hiero.base.utility.MemoryUtils;

public class PcesFileChannelWriter
implements PcesFileWriter {
    private static final int BUFFER_CAPACITY = 0xA00000;
    private final FileChannel channel;
    private ByteBuffer buffer;
    private WritableSequentialData writableSequentialData;
    private int fileSize;

    public PcesFileChannelWriter(@NonNull Path filePath) throws IOException {
        this(filePath, List.of());
    }

    public PcesFileChannelWriter(@NonNull Path filePath, @NonNull List<OpenOption> extraOpenOptions) throws IOException {
        ArrayList<StandardOpenOption> allOpenOptions = new ArrayList<StandardOpenOption>(List.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE));
        allOpenOptions.addAll(extraOpenOptions);
        this.channel = FileChannel.open(filePath, (OpenOption[])allOpenOptions.toArray(OpenOption[]::new));
        this.buffer = ByteBuffer.allocateDirect(0xA00000);
        this.writableSequentialData = BufferedData.wrap((ByteBuffer)this.buffer);
    }

    @Override
    public void writeVersion(int version) throws IOException {
        this.buffer.putInt(version);
        this.flipWriteClear();
    }

    @Override
    public long writeEvent(@NonNull GossipEvent event) throws IOException {
        boolean expandBuffer;
        int size = GossipEvent.PROTOBUF.measureRecord((Object)event);
        boolean bl = expandBuffer = size > this.buffer.capacity();
        if (expandBuffer) {
            MemoryUtils.closeDirectByteBuffer((ByteBuffer)this.buffer);
            this.buffer = ByteBuffer.allocateDirect(size);
            this.writableSequentialData = BufferedData.wrap((ByteBuffer)this.buffer);
        }
        this.buffer.putInt(size);
        GossipEvent.PROTOBUF.write((Object)event, this.writableSequentialData);
        this.flipWriteClear();
        return size;
    }

    private void flipWriteClear() throws IOException {
        this.buffer.flip();
        int bytesWritten = this.channel.write(this.buffer);
        this.fileSize += bytesWritten;
        if (bytesWritten != this.buffer.limit()) {
            throw new IOException("Failed to write data to file. Wrote " + bytesWritten + " bytes out of " + this.buffer.limit());
        }
        this.buffer.clear();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void sync() throws IOException {
        this.channel.force(false);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public long fileSize() {
        return this.fileSize;
    }
}

