/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.cli.logging;

import com.swirlds.cli.logging.CssDeclaration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class CssRuleSetFactory {
    private final List<String> rules = new ArrayList<String>();

    @NonNull
    private static String createRuleString(@NonNull String selector, @NonNull List<CssDeclaration> declarations) {
        return selector + " {\n" + String.join((CharSequence)"\n", declarations.stream().map(CssDeclaration::toString).toList()) + "\n}";
    }

    public void addRule(@NonNull String selector, CssDeclaration ... declarations) {
        Objects.requireNonNull(selector);
        Objects.requireNonNull(declarations);
        this.rules.add(CssRuleSetFactory.createRuleString(selector, Arrays.asList(declarations)));
    }

    @NonNull
    public String generateCss() {
        return String.join((CharSequence)"\n", this.rules);
    }
}

