/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api.internal.level;

import com.swirlds.config.api.Configuration;
import com.swirlds.logging.api.Level;
import com.swirlds.logging.api.Marker;
import com.swirlds.logging.api.internal.level.ConfigLevel;
import com.swirlds.logging.api.internal.level.MarkerState;
import com.swirlds.logging.utils.ConfigUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class HandlerLoggingLevelConfig {
    private static final String PROPERTY_LOGGING_LEVEL = "logging.level";
    private static final String PROPERTY_LOGGING_HANDLER_LEVEL = "logging.handler.%s.level";
    private static final String PROPERTY_PACKAGE_LEVEL = "%s.";
    private static final String PROPERTY_LOGGING_MARKER = "logging.marker";
    private static final String PROPERTY_LOGGING_HANDLER_MARKER = "logging.handler.%s.marker";
    private static final String PROPERTY_LOGGING_HANDLER_INHERIT_LEVELS = "logging.handler.%s.inheritLevels";
    private static final Level DEFAULT_LEVEL = Level.INFO;
    private final Map<String, Level> levelCache = new ConcurrentHashMap<String, Level>();
    private final Map<String, MarkerState> markerConfigCache;
    private final Map<String, Level> levelConfigProperties;

    private HandlerLoggingLevelConfig(Map<String, MarkerState> markerConfigCache, Map<String, Level> levelConfigProperties) {
        this.markerConfigCache = Collections.unmodifiableMap(markerConfigCache);
        this.levelConfigProperties = Collections.unmodifiableMap(levelConfigProperties);
    }

    public static HandlerLoggingLevelConfig create(Configuration configuration) {
        return HandlerLoggingLevelConfig.create(configuration, null);
    }

    @NonNull
    public static HandlerLoggingLevelConfig create(@NonNull Configuration configuration, @Nullable String handlerName) {
        Objects.requireNonNull(configuration, "configuration must not be null");
        ConfigLevel defaultLevel = ConfigUtils.configValueOrElse(configuration, PROPERTY_LOGGING_LEVEL, ConfigLevel.class, ConfigLevel.UNDEFINED);
        Boolean inheritLevels = ConfigUtils.configValueOrElse(configuration, PROPERTY_LOGGING_HANDLER_INHERIT_LEVELS.formatted(handlerName), Boolean.class, Boolean.TRUE);
        String propertyHandler = PROPERTY_LOGGING_HANDLER_LEVEL.formatted(handlerName);
        ConfigLevel defaultHandlerLevel = handlerName != null ? ConfigUtils.configValueOrElse(configuration, propertyHandler, ConfigLevel.class, ConfigLevel.UNDEFINED) : ConfigLevel.UNDEFINED;
        HashMap<String, Level> levelConfigProperties = new HashMap<String, Level>();
        HashMap<String, MarkerState> markerConfigStore = new HashMap<String, MarkerState>();
        if (defaultLevel == ConfigLevel.UNDEFINED && defaultHandlerLevel == ConfigLevel.UNDEFINED) {
            levelConfigProperties.put("", DEFAULT_LEVEL);
        } else if (defaultHandlerLevel != ConfigLevel.UNDEFINED) {
            levelConfigProperties.put("", defaultHandlerLevel.level());
        } else if (Boolean.TRUE.equals(inheritLevels)) {
            levelConfigProperties.put("", defaultLevel.level());
        } else {
            levelConfigProperties.put("", DEFAULT_LEVEL);
        }
        if (Boolean.TRUE.equals(inheritLevels)) {
            levelConfigProperties.putAll(HandlerLoggingLevelConfig.readLevels(PROPERTY_LOGGING_LEVEL, configuration));
            markerConfigStore.putAll(HandlerLoggingLevelConfig.readMarkers(PROPERTY_LOGGING_MARKER, configuration));
        }
        if (handlerName != null) {
            levelConfigProperties.putAll(HandlerLoggingLevelConfig.readLevels(propertyHandler, configuration));
            markerConfigStore.putAll(HandlerLoggingLevelConfig.readMarkers(PROPERTY_LOGGING_HANDLER_MARKER.formatted(handlerName), configuration));
        }
        return new HandlerLoggingLevelConfig(markerConfigStore, levelConfigProperties);
    }

    @NonNull
    private static Map<String, MarkerState> readMarkers(@NonNull String prefix, @NonNull Configuration configuration) {
        HashMap<String, MarkerState> result = new HashMap<String, MarkerState>();
        String fullPrefix = PROPERTY_PACKAGE_LEVEL.formatted(prefix);
        configuration.getPropertyNames().filter(n -> n.startsWith(fullPrefix)).forEach(configPropertyName -> {
            String name = configPropertyName.substring(fullPrefix.length());
            MarkerState markerState = (MarkerState)((Object)((Object)configuration.getValue(configPropertyName, MarkerState.class, (Object)MarkerState.UNDEFINED)));
            result.put(name, markerState);
        });
        return result;
    }

    @NonNull
    private static Map<String, Level> readLevels(@NonNull String prefix, @NonNull Configuration configuration) {
        HashMap result = new HashMap();
        String fullPrefix = PROPERTY_PACKAGE_LEVEL.formatted(prefix);
        configuration.getPropertyNames().filter(n -> n.startsWith(fullPrefix)).forEach(configPropertyName -> {
            String name = configPropertyName.substring(fullPrefix.length());
            ConfigLevel level = (ConfigLevel)((Object)((Object)configuration.getValue(configPropertyName, ConfigLevel.class, (Object)ConfigLevel.UNDEFINED)));
            if (level != null && level != ConfigLevel.UNDEFINED) {
                result.put(name, level.level());
            }
        });
        return Collections.unmodifiableMap(result);
    }

    public boolean isEnabled(@NonNull String name, @NonNull Level level) {
        Level enabledLevel = this.levelCache.computeIfAbsent(name, this::getConfiguredLevel);
        return enabledLevel.enabledLoggingOfLevel(level);
    }

    public boolean isEnabled(@NonNull String name, @NonNull Level level, @Nullable Marker marker) {
        if (marker != null) {
            List<String> allMarkerNames = marker.getAllMarkerNames();
            boolean isEnabled = false;
            boolean found = false;
            for (String markerName : allMarkerNames) {
                MarkerState markerState = this.markerConfigCache.get(markerName);
                if (MarkerState.ENABLED.equals((Object)markerState)) {
                    isEnabled = true;
                    found = true;
                    break;
                }
                if (!MarkerState.DISABLED.equals((Object)markerState)) continue;
                found = true;
            }
            if (found) {
                return isEnabled;
            }
        }
        return this.isEnabled(name, level);
    }

    @NonNull
    private Level getConfiguredLevel(@NonNull String name) {
        Level configLevel = this.levelConfigProperties.get(name);
        if (configLevel != null) {
            return configLevel;
        }
        StringBuilder buffer = new StringBuilder(name);
        for (int i = buffer.length() - 1; i > 0; --i) {
            if ('.' != buffer.charAt(i)) continue;
            buffer.setLength(i);
            configLevel = this.levelConfigProperties.get(buffer.toString());
            if (configLevel == null) continue;
            return configLevel;
        }
        return this.levelConfigProperties.get("");
    }
}

