/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.block.stream.codec;

import com.hedera.hapi.block.stream.BlockItem;
import com.hedera.hapi.block.stream.BlockProof;
import com.hedera.hapi.block.stream.FilteredItemHash;
import com.hedera.hapi.block.stream.RecordFileItem;
import com.hedera.hapi.block.stream.input.EventHeader;
import com.hedera.hapi.block.stream.input.RoundHeader;
import com.hedera.hapi.block.stream.output.BlockHeader;
import com.hedera.hapi.block.stream.output.StateChanges;
import com.hedera.hapi.block.stream.output.TransactionOutput;
import com.hedera.hapi.block.stream.output.TransactionResult;
import com.hedera.hapi.block.stream.trace.TraceData;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class BlockItemJsonCodec
implements JsonCodec<BlockItem> {
    public static final OneOf<BlockItem.ItemOneOfType> ITEM_UNSET = new OneOf((Enum)BlockItem.ItemOneOfType.UNSET, null);

    @NonNull
    public BlockItem parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            OneOf temp_item = ITEM_UNSET;
            block28: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "blockHeader": {
                        temp_item = new OneOf((Enum)BlockItem.ItemOneOfType.BLOCK_HEADER, BlockHeader.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1));
                        continue block28;
                    }
                    case "eventHeader": {
                        temp_item = new OneOf((Enum)BlockItem.ItemOneOfType.EVENT_HEADER, EventHeader.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1));
                        continue block28;
                    }
                    case "roundHeader": {
                        temp_item = new OneOf((Enum)BlockItem.ItemOneOfType.ROUND_HEADER, RoundHeader.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1));
                        continue block28;
                    }
                    case "signedTransaction": {
                        temp_item = new OneOf((Enum)BlockItem.ItemOneOfType.SIGNED_TRANSACTION, (Object)Bytes.fromBase64((String)kvPair.value().STRING().getText()));
                        continue block28;
                    }
                    case "transactionResult": {
                        temp_item = new OneOf((Enum)BlockItem.ItemOneOfType.TRANSACTION_RESULT, TransactionResult.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1));
                        continue block28;
                    }
                    case "transactionOutput": {
                        temp_item = new OneOf((Enum)BlockItem.ItemOneOfType.TRANSACTION_OUTPUT, TransactionOutput.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1));
                        continue block28;
                    }
                    case "stateChanges": {
                        temp_item = new OneOf((Enum)BlockItem.ItemOneOfType.STATE_CHANGES, StateChanges.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1));
                        continue block28;
                    }
                    case "filteredItemHash": {
                        temp_item = new OneOf((Enum)BlockItem.ItemOneOfType.FILTERED_ITEM_HASH, FilteredItemHash.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1));
                        continue block28;
                    }
                    case "blockProof": {
                        temp_item = new OneOf((Enum)BlockItem.ItemOneOfType.BLOCK_PROOF, BlockProof.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1));
                        continue block28;
                    }
                    case "recordFile": {
                        temp_item = new OneOf((Enum)BlockItem.ItemOneOfType.RECORD_FILE, RecordFileItem.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1));
                        continue block28;
                    }
                    case "traceData": {
                        temp_item = new OneOf((Enum)BlockItem.ItemOneOfType.TRACE_DATA, TraceData.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1));
                        continue block28;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new BlockItem(temp_item);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull BlockItem data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.item().kind() == BlockItem.ItemOneOfType.BLOCK_HEADER) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"blockHeader", BlockHeader.JSON, (Object)data.blockHeader()));
        }
        if (data.item().kind() == BlockItem.ItemOneOfType.EVENT_HEADER) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"eventHeader", EventHeader.JSON, (Object)data.eventHeader()));
        }
        if (data.item().kind() == BlockItem.ItemOneOfType.ROUND_HEADER) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"roundHeader", RoundHeader.JSON, (Object)data.roundHeader()));
        }
        if (data.item().kind() == BlockItem.ItemOneOfType.SIGNED_TRANSACTION) {
            fieldLines.add(JsonTools.field((String)"signedTransaction", (Bytes)data.signedTransaction()));
        }
        if (data.item().kind() == BlockItem.ItemOneOfType.TRANSACTION_RESULT) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"transactionResult", TransactionResult.JSON, (Object)data.transactionResult()));
        }
        if (data.item().kind() == BlockItem.ItemOneOfType.TRANSACTION_OUTPUT) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"transactionOutput", TransactionOutput.JSON, (Object)data.transactionOutput()));
        }
        if (data.item().kind() == BlockItem.ItemOneOfType.STATE_CHANGES) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"stateChanges", StateChanges.JSON, (Object)data.stateChanges()));
        }
        if (data.item().kind() == BlockItem.ItemOneOfType.FILTERED_ITEM_HASH) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"filteredItemHash", FilteredItemHash.JSON, (Object)data.filteredItemHash()));
        }
        if (data.item().kind() == BlockItem.ItemOneOfType.BLOCK_PROOF) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"blockProof", BlockProof.JSON, (Object)data.blockProof()));
        }
        if (data.item().kind() == BlockItem.ItemOneOfType.RECORD_FILE) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"recordFile", RecordFileItem.JSON, (Object)data.recordFile()));
        }
        if (data.item().kind() == BlockItem.ItemOneOfType.TRACE_DATA) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"traceData", TraceData.JSON, (Object)data.traceData()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

