/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.cli;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.cli.commands.StateCommand;
import com.swirlds.cli.utility.AbstractCommand;
import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.platform.config.DefaultConfiguration;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.snapshot.DeserializedSignedState;
import com.swirlds.platform.state.snapshot.SignedStateFileReader;
import com.swirlds.platform.system.address.AddressBookUtils;
import com.swirlds.platform.system.address.AddressBookValidator;
import com.swirlds.platform.util.BootstrapUtils;
import com.swirlds.state.State;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.concurrent.ExecutionException;
import org.hiero.consensus.model.roster.AddressBook;
import org.hiero.consensus.roster.RosterRetriever;
import org.hiero.consensus.roster.RosterUtils;
import picocli.CommandLine;

@CommandLine.Command(name="validateAddressBook", mixinStandardHelpOptions=true, description={"Validates the given address book as a successor to the address book in the given state."})
@SubcommandOf(value=StateCommand.class)
public class ValidateAddressBookStateCommand
extends AbstractCommand {
    private Path statePath;
    private Path addressBookPath;

    @CommandLine.Parameters(description={"The path to the state"}, index="0")
    private void setStatePath(Path statePath) {
        this.statePath = this.pathMustExist(statePath.toAbsolutePath());
    }

    @CommandLine.Parameters(description={"The path to the address book to validate as a successor"}, index="1")
    private void setAddressBookPath(Path addressBookPath) {
        this.addressBookPath = this.pathMustExist(addressBookPath.toAbsolutePath());
    }

    public Integer call() throws IOException, ExecutionException, InterruptedException, ParseException {
        AddressBook stateAddressBook;
        Configuration configuration = DefaultConfiguration.buildBasicConfiguration(ConfigurationBuilder.create());
        BootstrapUtils.setupConstructableRegistry();
        PlatformContext platformContext = PlatformContext.create((Configuration)configuration);
        System.out.printf("Reading state from %s %n", this.statePath.toAbsolutePath());
        DeserializedSignedState deserializedSignedState = SignedStateFileReader.readStateFile(this.statePath, virtualMap -> {
            throw new UnsupportedOperationException();
        }, PlatformStateFacade.DEFAULT_PLATFORM_STATE_FACADE, platformContext);
        System.out.printf("Reading address book from %s %n", this.addressBookPath.toAbsolutePath());
        String addressBookString = Files.readString(this.addressBookPath);
        AddressBook addressBook = AddressBookUtils.parseAddressBookText(addressBookString);
        try (ReservedSignedState reservedSignedState = deserializedSignedState.reservedSignedState();){
            System.out.printf("Extracting the state address book for comparison %n", new Object[0]);
            MerkleNodeState state = reservedSignedState.get().getState();
            stateAddressBook = RosterUtils.buildAddressBook((Roster)RosterRetriever.retrieveActive((State)state, (long)PlatformStateFacade.DEFAULT_PLATFORM_STATE_FACADE.roundOf(state)));
        }
        System.out.printf("Validating address book %n", new Object[0]);
        AddressBookValidator.validateNewAddressBook(stateAddressBook, addressBook);
        System.out.printf("PASS: The address book is valid as a successor to the state's address book %n", new Object[0]);
        return 0;
    }
}

