/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.system.status;

import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.formatting.UnitFormatter;
import com.swirlds.common.units.TimeUnit;
import com.swirlds.common.units.Unit;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.PlatformStatusPayload;
import com.swirlds.platform.system.status.IllegalPlatformStatusException;
import com.swirlds.platform.system.status.PlatformStatusConfig;
import com.swirlds.platform.system.status.PlatformStatusMetrics;
import com.swirlds.platform.system.status.StatusStateMachine;
import com.swirlds.platform.system.status.actions.CatastrophicFailureAction;
import com.swirlds.platform.system.status.actions.DoneReplayingEventsAction;
import com.swirlds.platform.system.status.actions.FallenBehindAction;
import com.swirlds.platform.system.status.actions.FreezePeriodEnteredAction;
import com.swirlds.platform.system.status.actions.PlatformStatusAction;
import com.swirlds.platform.system.status.actions.ReconnectCompleteAction;
import com.swirlds.platform.system.status.actions.SelfEventReachedConsensusAction;
import com.swirlds.platform.system.status.actions.StartedReplayingEventsAction;
import com.swirlds.platform.system.status.actions.StateWrittenToDiskAction;
import com.swirlds.platform.system.status.actions.TimeElapsedAction;
import com.swirlds.platform.system.status.logic.PlatformStatusLogic;
import com.swirlds.platform.system.status.logic.StartingUpStatusLogic;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.status.PlatformStatus;

public class DefaultStatusStateMachine
implements StatusStateMachine {
    private static final Logger logger = LogManager.getLogger(DefaultStatusStateMachine.class);
    private final Time time;
    private PlatformStatusLogic currentStatusLogic;
    private Instant currentStatusStartTime;
    private final PlatformStatusMetrics metrics;

    public DefaultStatusStateMachine(@NonNull PlatformContext platformContext) {
        this.time = platformContext.getTime();
        this.currentStatusLogic = new StartingUpStatusLogic((PlatformStatusConfig)platformContext.getConfiguration().getConfigData(PlatformStatusConfig.class));
        this.currentStatusStartTime = this.time.now();
        this.metrics = new PlatformStatusMetrics(platformContext);
    }

    @Nullable
    private PlatformStatusLogic getNewLogic(@NonNull PlatformStatusAction action) {
        Objects.requireNonNull(action);
        Class<?> actionClass = action.getClass();
        try {
            if (actionClass == CatastrophicFailureAction.class) {
                return this.currentStatusLogic.processCatastrophicFailureAction((CatastrophicFailureAction)action);
            }
            if (actionClass == DoneReplayingEventsAction.class) {
                return this.currentStatusLogic.processDoneReplayingEventsAction((DoneReplayingEventsAction)action);
            }
            if (actionClass == FallenBehindAction.class) {
                return this.currentStatusLogic.processFallenBehindAction((FallenBehindAction)action);
            }
            if (actionClass == FreezePeriodEnteredAction.class) {
                return this.currentStatusLogic.processFreezePeriodEnteredAction((FreezePeriodEnteredAction)action);
            }
            if (actionClass == ReconnectCompleteAction.class) {
                return this.currentStatusLogic.processReconnectCompleteAction((ReconnectCompleteAction)action);
            }
            if (actionClass == SelfEventReachedConsensusAction.class) {
                return this.currentStatusLogic.processSelfEventReachedConsensusAction((SelfEventReachedConsensusAction)action);
            }
            if (actionClass == StartedReplayingEventsAction.class) {
                return this.currentStatusLogic.processStartedReplayingEventsAction((StartedReplayingEventsAction)action);
            }
            if (actionClass == StateWrittenToDiskAction.class) {
                return this.currentStatusLogic.processStateWrittenToDiskAction((StateWrittenToDiskAction)action);
            }
            if (actionClass == TimeElapsedAction.class) {
                return this.currentStatusLogic.processTimeElapsedAction((TimeElapsedAction)action);
            }
            throw new IllegalArgumentException("Unknown action type: " + action.getClass().getName());
        }
        catch (IllegalPlatformStatusException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    @Nullable
    public PlatformStatus submitStatusAction(@NonNull PlatformStatusAction action) {
        Objects.requireNonNull(action);
        PlatformStatusLogic newLogic = this.getNewLogic(action);
        if (newLogic == null || newLogic == this.currentStatusLogic) {
            return null;
        }
        String previousStatusName = this.currentStatusLogic.getStatus().name();
        String newStatusName = newLogic.getStatus().name();
        Duration statusDuration = Duration.between(this.currentStatusStartTime, this.time.now());
        UnitFormatter unitFormatter = new UnitFormatter(statusDuration.toMillis(), (Unit)TimeUnit.UNIT_MILLISECONDS);
        String statusChangeMessage = "Platform spent %s in %s. Now in %s".formatted(unitFormatter.render(), previousStatusName, newStatusName);
        logger.info(LogMarker.PLATFORM_STATUS.getMarker(), () -> new PlatformStatusPayload(statusChangeMessage, previousStatusName, newStatusName).toString());
        this.currentStatusLogic = newLogic;
        PlatformStatus newStatus = this.currentStatusLogic.getStatus();
        this.currentStatusStartTime = this.time.now();
        this.metrics.setCurrentStatus(newStatus);
        return newStatus;
    }

    @Override
    @Nullable
    public PlatformStatus heartbeat(@NonNull Instant time) {
        return this.submitStatusAction(new TimeElapsedAction(time));
    }
}

