/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.util;

import com.swirlds.platform.util.CommandResult;
import com.swirlds.platform.util.ProgressIndicator;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public final class VirtualTerminal {
    private boolean printStdout;
    private boolean printStderr;
    private boolean printCommand;
    private boolean printExitCode;
    private boolean throwOnError;
    private boolean progressIndicatorEnabled;
    private final ProgressIndicator progressIndicator = new ProgressIndicator(1);

    @NonNull
    public VirtualTerminal setPrintStdout(boolean printStdout) {
        this.printStdout = printStdout;
        return this;
    }

    @NonNull
    public VirtualTerminal setPrintStderr(boolean printStderr) {
        this.printStderr = printStderr;
        return this;
    }

    @NonNull
    public VirtualTerminal setPrintCommand(boolean printCommand) {
        this.printCommand = printCommand;
        return this;
    }

    @NonNull
    public VirtualTerminal setPrintExitCode(boolean printExitCode) {
        this.printExitCode = printExitCode;
        return this;
    }

    @NonNull
    public VirtualTerminal setThrowOnError(boolean throwOnError) {
        this.throwOnError = throwOnError;
        return this;
    }

    @NonNull
    public VirtualTerminal setProgressIndicatorEnabled(boolean progressIndicatorEnabled) {
        this.progressIndicatorEnabled = progressIndicatorEnabled;
        return this;
    }

    @NonNull
    public ProgressIndicator getProgressIndicator() {
        return this.progressIndicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public CommandResult run(String ... command) {
        try {
            if (this.printCommand) {
                System.out.println("VirtualTerminal > " + String.join((CharSequence)" ", command));
            }
            StringBuilder in = new StringBuilder();
            StringBuilder err = new StringBuilder();
            int exitCode = this.run((String s) -> in.append((String)s).append("\n"), (String s) -> err.append((String)s).append("\n"), command);
            String outString = in.toString();
            String errString = err.toString();
            if (this.printStdout && !outString.isEmpty()) {
                System.out.println(outString);
            }
            if (this.printStderr && !errString.isEmpty()) {
                System.err.println(errString);
            }
            if (this.printExitCode) {
                System.out.println("Exit code: " + exitCode);
            }
            if (this.throwOnError && exitCode != 0) {
                throw new RuntimeException("Command failed: " + String.join((CharSequence)" ", command));
            }
            CommandResult commandResult = new CommandResult(exitCode, outString, errString);
            return commandResult;
        }
        finally {
            if (this.progressIndicatorEnabled) {
                this.progressIndicator.increment();
            }
        }
    }

    public int run(@NonNull Consumer<String> stdoutHandler, @NonNull Consumer<String> stderrHandler, String ... command) {
        try {
            String line;
            if (this.printCommand) {
                System.out.println("VirtualTerminal > " + String.join((CharSequence)" ", command));
            }
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(command);
            BufferedReader stdin = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader stderr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = stdin.readLine()) != null) {
                stdoutHandler.accept(line);
            }
            while ((line = stderr.readLine()) != null) {
                stderrHandler.accept(line);
            }
            while (process.isAlive()) {
                TimeUnit.MILLISECONDS.sleep(1L);
            }
            int exitCode = process.exitValue();
            if (this.printExitCode) {
                System.out.println("Exit code: " + exitCode);
            }
            if (this.throwOnError && exitCode != 0) {
                throw new RuntimeException("Command failed: " + String.join((CharSequence)" ", command));
            }
            int n = exitCode;
            return n;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("interrupted while running command", e);
        }
        finally {
            if (this.progressIndicatorEnabled) {
                this.progressIndicator.increment();
            }
        }
    }
}

