/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.extensions.sources;

import com.swirlds.config.extensions.sources.AbstractConfigSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public abstract class AbstractFileConfigSource
extends AbstractConfigSource {
    @NonNull
    protected final Map<String, String> internalProperties = new HashMap<String, String>();
    @NonNull
    protected final Path filePath;
    protected final int ordinal;

    protected AbstractFileConfigSource(@NonNull Path filePath) throws IOException {
        this(filePath, 200);
    }

    protected AbstractFileConfigSource(@NonNull Path filePath, int ordinal) throws IOException {
        this.filePath = Objects.requireNonNull(filePath, "filePath can not be null");
        this.ordinal = ordinal;
        try (BufferedReader reader = this.getReader();){
            Properties loadedProperties = new Properties();
            loadedProperties.load(reader);
            loadedProperties.stringPropertyNames().forEach(name -> this.internalProperties.put((String)name, loadedProperties.getProperty((String)name)));
        }
    }

    @NonNull
    public String getName() {
        return "Property file config source for " + String.valueOf(this.filePath);
    }

    @Override
    @NonNull
    protected Map<String, String> getInternalProperties() {
        return Collections.unmodifiableMap(this.internalProperties);
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @NonNull
    protected abstract BufferedReader getReader() throws IOException;
}

