/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.collections;

import com.swirlds.merkledb.collections.ImmutableIndexedObjectList;
import com.swirlds.merkledb.collections.IndexedObject;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Stream;

public class ImmutableIndexedObjectListUsingMap<T extends IndexedObject>
implements ImmutableIndexedObjectList<T> {
    private final SortedMap<Integer, T> dataMap;

    public ImmutableIndexedObjectListUsingMap(T[] objects) {
        Objects.requireNonNull(objects);
        TreeMap<Integer, T> map = new TreeMap<Integer, T>();
        for (T object : objects) {
            if (object == null) continue;
            map.put(object.getIndex(), object);
        }
        this.dataMap = Collections.unmodifiableSortedMap(map);
    }

    @Override
    public ImmutableIndexedObjectListUsingMap<T> withAddedObject(T newT) {
        if (newT == null) {
            return this;
        }
        TreeMap<Integer, T> map = new TreeMap<Integer, T>(this.dataMap);
        map.put(newT.getIndex(), newT);
        return new ImmutableIndexedObjectListUsingMap<T>(Collections.unmodifiableSortedMap(map));
    }

    @Override
    public ImmutableIndexedObjectListUsingMap<T> withDeletedObjects(@NonNull Collection<T> objectsToDelete) {
        if (objectsToDelete.isEmpty() || this.dataMap.isEmpty()) {
            return this;
        }
        TreeMap<Integer, T> map = new TreeMap<Integer, T>(this.dataMap);
        for (IndexedObject object : objectsToDelete) {
            if (object == null) continue;
            map.remove(object.getIndex());
        }
        return new ImmutableIndexedObjectListUsingMap<T>(Collections.unmodifiableSortedMap(map));
    }

    @Override
    public T getLast() {
        return (T)(this.dataMap.isEmpty() ? null : (IndexedObject)this.dataMap.get(this.dataMap.lastKey()));
    }

    @Override
    public T get(int objectIndex) {
        if (objectIndex < 0) {
            throw new IndexOutOfBoundsException("Cannot use negative index " + objectIndex);
        }
        return (T)((IndexedObject)this.dataMap.get(objectIndex));
    }

    @Override
    public Stream<T> stream() {
        return this.dataMap.values().stream();
    }

    public String toString() {
        return this.prettyPrintedIndices();
    }

    private ImmutableIndexedObjectListUsingMap(SortedMap<Integer, T> dataMap) {
        this.dataMap = dataMap;
    }

    @Override
    public int size() {
        return this.dataMap.size();
    }
}

