/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkle.test.fixtures.map.benchmark;

import com.swirlds.common.test.fixtures.benchmark.BenchmarkMetadata;
import com.swirlds.merkle.test.fixtures.map.benchmark.BenchmarkKey;
import com.swirlds.merkle.test.fixtures.map.benchmark.RandomKeySet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class MerkleMapBenchmarkMetadata
implements BenchmarkMetadata {
    private final RandomKeySet<Long> keys = new RandomKeySet();
    private long nextKey;
    private final long networkFeeKey = this.nextKey++;
    private final List<Long> nodeFeeKeys = new ArrayList<Long>(13);
    private final Set<Long> undeletableKeys;
    private static final int NUMBER_OF_NODES = 13;

    public MerkleMapBenchmarkMetadata() {
        for (int i = 0; i < 13; ++i) {
            this.nodeFeeKeys.add(this.nextKey++);
        }
        this.undeletableKeys = new HashSet<Long>();
    }

    public synchronized BenchmarkKey getNewKey() {
        long key = this.nextKey++;
        this.keys.add(key);
        return new BenchmarkKey(key);
    }

    public synchronized BenchmarkKey getRandomKey(Random random) {
        return new BenchmarkKey(this.keys.getRandomKey(random));
    }

    public synchronized void deleteKey(BenchmarkKey key) {
        this.keys.remove(key.getValue());
    }

    public BenchmarkKey getNetworkFeeKey() {
        return new BenchmarkKey(this.networkFeeKey);
    }

    public BenchmarkKey getRandomNodeFeeKey(Random random) {
        return new BenchmarkKey(this.nodeFeeKeys.get(random.nextInt(this.nodeFeeKeys.size())));
    }

    public List<BenchmarkKey> getNodeFeeKeys() {
        LinkedList<BenchmarkKey> keys = new LinkedList<BenchmarkKey>();
        for (long key : this.nodeFeeKeys) {
            keys.add(new BenchmarkKey(key));
        }
        return keys;
    }

    public void markKeyAsUndeletable(BenchmarkKey key) {
        this.undeletableKeys.add(key.getValue());
    }

    public void markKeyAsDeletable(BenchmarkKey key) {
        this.undeletableKeys.remove(key.getValue());
    }

    public boolean isKeyUndeletable(BenchmarkKey key) {
        return this.undeletableKeys.contains(key.getValue());
    }
}

