/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.synchronization.task;

import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.synchronization.stats.ReconnectMapStats;
import com.swirlds.common.merkle.synchronization.streams.AsyncInputStream;
import com.swirlds.common.merkle.synchronization.streams.AsyncOutputStream;
import com.swirlds.common.merkle.synchronization.task.ExpectedLesson;
import com.swirlds.common.merkle.synchronization.task.Lesson;
import com.swirlds.common.merkle.synchronization.task.QueryResponse;
import com.swirlds.common.merkle.synchronization.task.ReconnectNodeCount;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.merkle.synchronization.views.CustomReconnectRoot;
import com.swirlds.common.merkle.synchronization.views.LearnerTreeView;
import com.swirlds.common.threading.pool.StandardWorkGroup;
import com.swirlds.common.utility.ThresholdLimitingHandler;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.constructable.ClassIdFormatter;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.crypto.Hash;

public class LearnerPushTask<T> {
    private static final Logger logger = LogManager.getLogger(LearnerPushTask.class);
    private static final String NAME = "learner-task";
    private final StandardWorkGroup workGroup;
    private final AsyncInputStream<Lesson<T>> in;
    private final AsyncOutputStream<QueryResponse> out;
    private final AtomicReference<T> root;
    private final LearnerTreeView<T> view;
    private final ReconnectNodeCount nodeCount;
    private final ReconnectMapStats mapStats;
    private final Queue<MerkleNode> rootsToReceive;
    private final ThresholdLimitingHandler<Throwable> exceptionRateLimiter = new ThresholdLimitingHandler(1L);

    public LearnerPushTask(StandardWorkGroup workGroup, AsyncInputStream<Lesson<T>> in, AsyncOutputStream<QueryResponse> out, Queue<MerkleNode> rootsToReceive, AtomicReference<T> root, LearnerTreeView<T> view, ReconnectNodeCount nodeCount, @NonNull ReconnectMapStats mapStats) {
        this.workGroup = workGroup;
        this.in = in;
        this.out = out;
        this.rootsToReceive = rootsToReceive;
        this.root = root;
        this.view = view;
        this.nodeCount = nodeCount;
        this.mapStats = mapStats;
    }

    public void start() {
        this.workGroup.execute(NAME, this::run);
    }

    private T handleCustomRootInitialLesson(LearnerTreeView<T> view, ExpectedLesson<T> expectedLesson, Lesson<T> lesson) {
        T originalNode = expectedLesson.getOriginalNode();
        CustomReconnectRoot customRoot = (CustomReconnectRoot)ConstructableRegistry.getInstance().createObject(lesson.getCustomViewClassId());
        if (customRoot == null) {
            throw new MerkleSynchronizationException("unable to construct object with class ID " + ClassIdFormatter.classIdString((long)lesson.getCustomViewClassId()));
        }
        if (originalNode != null && view.getClassId(originalNode) == lesson.getCustomViewClassId()) {
            customRoot.setupWithOriginalNode(view.getMerkleRoot(originalNode));
        } else {
            customRoot.setupWithNoData();
        }
        this.rootsToReceive.add(customRoot);
        return view.convertMerkleRootToViewType(customRoot);
    }

    private T extractNodeFromLesson(LearnerTreeView<T> view, ExpectedLesson<T> expectedLesson, Lesson<T> lesson, boolean firstLesson) {
        if (lesson.isCurrentNodeUpToDate()) {
            return expectedLesson.getOriginalNode();
        }
        if (lesson.isCustomViewRoot()) {
            return this.handleCustomRootInitialLesson(view, expectedLesson, lesson);
        }
        T node = firstLesson && !view.isRootOfState() ? expectedLesson.getOriginalNode() : lesson.getNode();
        if (lesson.isInternalLesson()) {
            view.markForInitialization(node);
        }
        return node;
    }

    private void handleQueries(LearnerTreeView<T> view, AsyncInputStream<Lesson<T>> in, AsyncOutputStream<QueryResponse> out, List<Hash> queries, T originalParent, T newParent) throws InterruptedException {
        int childCount = queries.size();
        for (int childIndex = 0; childIndex < childCount; ++childIndex) {
            Object originalChild = view.isInternal(originalParent, true) && view.getNumberOfChildren(originalParent) > childIndex ? (Object)view.getChild(originalParent, childIndex) : null;
            Hash originalHash = view.getNodeHash(originalChild);
            Hash teacherHash = queries.get(childIndex);
            if (originalHash == null) {
                this.exceptionRateLimiter.handle(new NullPointerException(), error -> logger.warn(LogMarker.RECONNECT.getMarker(), "originalHash for node {} is null", originalChild));
            }
            boolean nodeAlreadyPresent = originalHash != null && originalHash.equals((Object)teacherHash);
            out.sendAsync(new QueryResponse(nodeAlreadyPresent));
            this.mapStats.incrementTransfersFromLearner();
            view.recordHashStats(this.mapStats, newParent, childIndex, nodeAlreadyPresent);
            view.expectLessonFor(newParent, childIndex, originalChild, nodeAlreadyPresent);
            in.anticipateMessage();
        }
    }

    private void addToNodeCount(ExpectedLesson<T> expectedLesson, Lesson<T> lesson, T newChild) {
        if (lesson.isLeafLesson()) {
            this.mapStats.incrementLeafData(1, expectedLesson.isNodeAlreadyPresent() ? 1 : 0);
        }
        if (lesson.isCurrentNodeUpToDate()) {
            return;
        }
        if (this.view.isInternal(newChild, false)) {
            this.nodeCount.incrementInternalCount();
            if (expectedLesson.isNodeAlreadyPresent()) {
                this.nodeCount.incrementRedundantInternalCount();
            }
        } else {
            this.nodeCount.incrementLeafCount();
            if (expectedLesson.isNodeAlreadyPresent()) {
                this.nodeCount.incrementRedundantLeafCount();
            }
        }
    }

    private void run() {
        boolean firstLesson = true;
        try (AsyncInputStream<Lesson<T>> asyncInputStream = this.in;
             AsyncOutputStream<QueryResponse> asyncOutputStream = this.out;
             LearnerTreeView<T> learnerTreeView = this.view;){
            this.view.expectLessonFor(null, 0, this.view.getOriginalRoot(), false);
            this.in.anticipateMessage();
            while (this.view.hasNextExpectedLesson()) {
                ExpectedLesson expectedLesson = this.view.getNextExpectedLesson();
                Lesson<T> lesson = this.in.readAnticipatedMessage();
                this.mapStats.incrementTransfersFromTeacher();
                Object parent = expectedLesson.getParent();
                T newChild = this.extractNodeFromLesson(this.view, expectedLesson, lesson, firstLesson);
                firstLesson = false;
                if (parent == null) {
                    this.root.set(newChild);
                } else {
                    this.view.setChild(parent, expectedLesson.getPositionInParent(), newChild);
                }
                this.addToNodeCount(expectedLesson, lesson, newChild);
                if (!lesson.hasQueries()) continue;
                List<Hash> queries = lesson.getQueries();
                this.handleQueries(this.view, this.in, this.out, queries, expectedLesson.getOriginalNode(), newChild);
            }
            logger.info(LogMarker.RECONNECT.getMarker(), "learner thread finished the learning loop for the current subtree");
        }
        catch (InterruptedException ex) {
            logger.warn(LogMarker.RECONNECT.getMarker(), "learner thread interrupted");
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "exception in the learner's receiving thread", (Throwable)ex);
            throw new MerkleSynchronizationException("exception in the learner's receiving thread", ex);
        }
        logger.info(LogMarker.RECONNECT.getMarker(), "learner thread closed input, output, and view for the current subtree");
    }
}

