/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.disk;

import com.hedera.hapi.platform.state.QueueState;
import com.hedera.hapi.platform.state.StateValue;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.merkle.StateUtils;
import com.swirlds.state.merkle.disk.OnDiskQueueHelper;
import com.swirlds.state.merkle.logging.StateLogger;
import com.swirlds.state.spi.WritableQueueStateBase;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.Objects;

public class OnDiskWritableQueueState<E>
extends WritableQueueStateBase<E> {
    @NonNull
    private final VirtualMap virtualMap;
    @NonNull
    private final OnDiskQueueHelper<E> onDiskQueueHelper;

    public OnDiskWritableQueueState(@NonNull String serviceName, @NonNull String stateKey, @NonNull VirtualMap virtualMap) {
        super(serviceName, stateKey);
        this.virtualMap = Objects.requireNonNull(virtualMap);
        this.onDiskQueueHelper = new OnDiskQueueHelper(serviceName, stateKey, virtualMap);
    }

    protected void addToDataSource(@NonNull E element) {
        QueueState state = this.onDiskQueueHelper.getState();
        if (state == null) {
            state = new QueueState(1L, 1L);
        }
        Bytes keyBytes = StateUtils.getStateKeyForQueue(this.serviceName, this.stateKey, state.tail());
        StateValue stateValue = StateUtils.getStateValue(this.serviceName, this.stateKey, element);
        this.virtualMap.put(keyBytes, (Object)stateValue, StateValue.PROTOBUF);
        this.onDiskQueueHelper.updateState(new QueueState(state.head(), state.tail() + 1L));
        StateLogger.logQueueAdd(StateUtils.computeLabel(this.serviceName, this.stateKey), element);
    }

    protected void removeFromDataSource() {
        QueueState state = Objects.requireNonNull(this.onDiskQueueHelper.getState());
        if (!OnDiskQueueHelper.isEmpty(state)) {
            StateValue stateValue = (StateValue)this.virtualMap.remove(StateUtils.getStateKeyForQueue(this.serviceName, this.stateKey, state.head()), StateValue.PROTOBUF);
            this.onDiskQueueHelper.updateState(new QueueState(state.head() + 1L, state.tail()));
            Object removedValue = stateValue != null ? stateValue.value().as() : null;
            StateLogger.logQueueRemove(StateUtils.computeLabel(this.serviceName, this.stateKey), removedValue);
        } else {
            StateLogger.logQueueRemove(StateUtils.computeLabel(this.serviceName, this.stateKey), null);
        }
    }

    @NonNull
    protected Iterator<E> iterateOnDataSource() {
        return this.onDiskQueueHelper.iterateOnDataSource();
    }
}

