/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.concurrent.locks.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hiero.base.concurrent.locks.IndexLock;
import org.hiero.base.concurrent.locks.locked.Locked;

public final class DefaultIndexLock
implements IndexLock {
    private final int parallelism;
    private final Lock[] locks;

    public DefaultIndexLock(int parallelism) {
        this.parallelism = parallelism;
        this.locks = new Lock[parallelism];
        for (int lockIndex = 0; lockIndex < parallelism; ++lockIndex) {
            this.locks[lockIndex] = new ReentrantLock();
        }
    }

    @Override
    public void lock(long index) {
        this.locks[(int)(Math.abs(index) % (long)this.parallelism)].lock();
    }

    @Override
    public void lock(@Nullable Object object) {
        int hash = object == null ? 0 : object.hashCode();
        this.lock(hash);
    }

    @Override
    public void unlock(long index) {
        this.locks[(int)(Math.abs(index) % (long)this.parallelism)].unlock();
    }

    @Override
    public void unlock(@Nullable Object object) {
        int hash = object == null ? 0 : object.hashCode();
        this.unlock(hash);
    }

    @Override
    @NonNull
    public Locked autoLock(long index) {
        this.lock(index);
        return () -> this.unlock(index);
    }

    @Override
    @NonNull
    public Locked autoLock(@Nullable Object object) {
        int hash = object == null ? 0 : object.hashCode();
        return this.autoLock(hash);
    }

    @Override
    public void fullyLock() {
        for (int index = 0; index < this.parallelism; ++index) {
            this.locks[index].lock();
        }
    }

    @Override
    public void fullyUnlock() {
        for (int index = 0; index < this.parallelism; ++index) {
            this.locks[index].unlock();
        }
    }

    @Override
    @NonNull
    public Locked autoFullLock() {
        this.fullyLock();
        return this::fullyUnlock;
    }
}

