/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.merkle.util;

import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.MerkleDataOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class PairedStreams
implements AutoCloseable {
    protected BufferedOutputStream teacherOutputBuffer;
    protected MerkleDataOutputStream teacherOutput;
    protected BufferedInputStream teacherInputBuffer;
    protected MerkleDataInputStream teacherInput;
    protected BufferedOutputStream learnerOutputBuffer;
    protected MerkleDataOutputStream learnerOutput;
    protected BufferedInputStream learnerInputBuffer;
    protected MerkleDataInputStream learnerInput;
    protected Socket teacherSocket;
    protected Socket learnerSocket;
    protected ServerSocket server = new ServerSocket(0);

    public PairedStreams() throws IOException {
        this.teacherSocket = new Socket("127.0.0.1", this.server.getLocalPort());
        this.learnerSocket = this.server.accept();
        this.teacherOutputBuffer = new BufferedOutputStream(this.teacherSocket.getOutputStream());
        this.teacherOutput = new MerkleDataOutputStream((OutputStream)this.teacherOutputBuffer);
        this.teacherInputBuffer = new BufferedInputStream(this.teacherSocket.getInputStream());
        this.teacherInput = new MerkleDataInputStream((InputStream)this.teacherInputBuffer);
        this.learnerOutputBuffer = new BufferedOutputStream(this.learnerSocket.getOutputStream());
        this.learnerOutput = new MerkleDataOutputStream((OutputStream)this.learnerOutputBuffer);
        this.learnerInputBuffer = new BufferedInputStream(this.learnerSocket.getInputStream());
        this.learnerInput = new MerkleDataInputStream((InputStream)this.learnerInputBuffer);
    }

    public MerkleDataOutputStream getTeacherOutput() {
        return this.teacherOutput;
    }

    public MerkleDataInputStream getTeacherInput() {
        return this.teacherInput;
    }

    public MerkleDataOutputStream getLearnerOutput() {
        return this.learnerOutput;
    }

    public MerkleDataInputStream getLearnerInput() {
        return this.learnerInput;
    }

    @Override
    public void close() {
        try {
            this.teacherOutput.close();
            this.teacherInput.close();
            this.learnerOutput.close();
            this.learnerInput.close();
            this.teacherOutputBuffer.close();
            this.teacherInputBuffer.close();
            this.learnerOutputBuffer.close();
            this.learnerInputBuffer.close();
            this.server.close();
            this.teacherSocket.close();
            this.learnerSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void disconnect() {
        try {
            this.server.close();
            this.teacherSocket.close();
            this.learnerSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

