/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.communication.states;

import com.swirlds.platform.network.Connection;
import com.swirlds.platform.network.NetworkProtocolException;
import com.swirlds.platform.network.communication.NegotiationException;
import com.swirlds.platform.network.communication.states.NegotiationState;
import com.swirlds.platform.network.communication.states.NegotiationStateWithDescription;
import com.swirlds.platform.network.protocol.PeerProtocol;
import java.io.IOException;

public class ProtocolNegotiated
extends NegotiationStateWithDescription {
    private final Connection connection;
    private PeerProtocol peerProtocol;

    public ProtocolNegotiated(Connection connection) {
        this.connection = connection;
    }

    public NegotiationState runProtocol(PeerProtocol peerProtocol) {
        this.peerProtocol = peerProtocol;
        return this;
    }

    @Override
    public NegotiationState transition() throws NegotiationException, NetworkProtocolException, IOException, InterruptedException {
        if (this.peerProtocol == null) {
            throw new IllegalStateException("Cannot run a protocol because it is null");
        }
        try {
            this.peerProtocol.runProtocol(this.connection);
        }
        finally {
            this.setDescription("ran protocol " + this.peerProtocol.getProtocolName());
            this.peerProtocol = null;
        }
        return null;
    }
}

