/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.event.emitter;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.platform.internal.EventImpl;
import com.swirlds.platform.test.fixtures.event.emitter.BufferingEventEmitter;
import com.swirlds.platform.test.fixtures.event.generator.GraphGenerator;
import java.util.List;
import java.util.Queue;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterUtils;

public class PriorityEventEmitter
extends BufferingEventEmitter {
    private final List<Integer> nodePriorities;

    public PriorityEventEmitter(GraphGenerator graphGenerator, List<Integer> nodePriorities) {
        super(graphGenerator);
        this.nodePriorities = nodePriorities;
    }

    public PriorityEventEmitter(PriorityEventEmitter that) {
        this(that.getGraphGenerator().cleanCopy(), that.nodePriorities);
        this.setCheckpoint(that.getCheckpoint());
    }

    @Override
    public EventImpl emitEvent() {
        for (int nodeIndex : this.nodePriorities) {
            NodeId nodeId = RosterUtils.getNodeId((Roster)this.getGraphGenerator().getRoster(), (int)nodeIndex);
            this.attemptToGenerateEventFromNode(nodeId);
            if (!this.isReadyToEmitEvent(nodeId)) continue;
            this.eventEmittedFromBuffer();
            return (EventImpl)((Queue)this.events.get(nodeId)).remove();
        }
        return null;
    }

    @Override
    public PriorityEventEmitter cleanCopy() {
        return new PriorityEventEmitter(this);
    }

    @Override
    public PriorityEventEmitter cleanCopy(long seed) {
        return new PriorityEventEmitter(this);
    }
}

